/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEGroup;
import ScrollerGame.SCLevel;
import ScrollerGame.SCStaticEnemy;
import contentHeliStrike.grh;

public class SCTruckEnemy
extends SCStaticEnemy {
    public SCTruckEnemy(AEGraphNode geometry, AEGraphNode destroyed_geometry, int tx, int ty, int tz, int rx, int ry, int rz, int hitpoints, int hitradius, AEExplosionInterface explosion, int[] target_count_array, int target_count_id, long tile) {
        super(geometry, destroyed_geometry, tx, ty, tz, rx, ry, rz, hitpoints, hitradius, explosion, target_count_array, target_count_id, tile);
    }

    public SCTruckEnemy(AEGraphNode geometry, int tx, int ty, int tz, int rx, int ry, int rz, int hitpoints, int hitradius, AEExplosionInterface explosion, int[] target_count_array, int target_count_id, long tile) {
        this(geometry, null, tx, ty, tz, rx, ry, rz, hitpoints, hitradius, explosion, target_count_array, target_count_id, tile);
    }

    public void update(int elapsed_time) {
        if (this.isDead()) {
            this.enemy_set.removeEnemy(this);
            if (this.geometry.getParent() != null) {
                this.geometry.getParent().removeChild(this.geometry);
            }
            if (this.explosion != null && this.explosion.getParticleSystem().getParent() != null) {
                this.explosion.getParticleSystem().getParent().removeChild(this.explosion.getParticleSystem());
            }
        } else {
            this.geometry.translate(elapsed_time >> 1, 0, 0);
            if (this.geometry.getPositionX() > 2048) {
                this.geometry.setTranslation(-2048, this.geometry.getPositionY(), this.geometry.getPositionZ());
            }
        }
        if (this.explosion != null && this.explosion.isActive()) {
            this.explosion.update(elapsed_time);
        }
        int dx = this.geometry.getWorldPositionX() - SCLevel.getCurrentX();
        int dz = this.geometry.getWorldPositionZ() - SCLevel.getCurrentZ();
        dx = dx < 0 ? -dx : dx;
        int n = dz = dz < 0 ? -dz : dz;
        if (dz > dx) {
            this.corrected_hitradius_z = this.hitradius - ((dz * (this.geometry.getWorldPositionY() - 700) >> 12) * 4096 >> 12);
            this.corrected_hitradius_x = this.hitradius;
        } else {
            this.corrected_hitradius_x = this.hitradius - ((dx * (this.geometry.getWorldPositionY() - 700) >> 12) * 4096 >> 12);
            this.corrected_hitradius_z = this.hitradius;
        }
    }

    public void applyHitpoints(int hitpoints) {
        if (this.hitpoints <= 0) {
            return;
        }
        this.hitpoints += hitpoints;
        if (this.hitpoints <= 0) {
            AEGroup modul_root = this.geometry.getParent();
            if (modul_root != null) {
                if (this.destroyed_geometry != null) {
                    modul_root.removeChild(this.geometry);
                    modul_root.addChild(this.destroyed_geometry);
                    this.destroyed_geometry.setTranslation(this.geometry.getPositionX(), this.geometry.getPositionY(), this.geometry.getPositionZ());
                    this.destroyed_geometry.playAnim((byte)1);
                } else {
                    this.geometry.playAnim((byte)1);
                }
            }
            if (this.explosion != null) {
                this.explosion.getParticleSystem().setTranslation(this.geometry.getPositionX(), this.geometry.getPositionY(), this.geometry.getPositionZ());
                this.explosion.start();
            }
            if (this.target_count_array != null) {
                int n = this.target_count_id;
                this.target_count_array[n] = this.target_count_array[n] + 1;
            }
            ++grh.hit_notify;
        }
    }
}

