/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEGroup;
import AbyssEngine.AEScene;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCEnemySet;
import ScrollerGame.SCLevel;
import ScrollerGame.SCWeaponSystem;
import contentHeliStrike.grh;
import java.util.Random;

public class SCHeliEnemy
implements SCEnemy {
    private AEGraphNode base1;
    private int hitpoints;
    private int initial_hitpoints;
    private int hitradius;
    private SCEnemySet enemy_set;
    private AEExplosionInterface explosion;
    private SCWeaponSystem weapon;
    private int[] target_count_array;
    private int target_count_id;
    private long tile;
    private static final int MAX_DX = 1024;
    private static final int MAX_DZ = 1024;
    private static final int MAX_SPEED_DX = 4096;
    private static final int MIN_SPEED_DX = 64;
    private static final int MAX_SPEED_DZ = 4096;
    private static final int MIN_SPEED_DZ = 64;
    private static final int MIN_TIME_IDLE = 2000;
    private static final int MAX_TIME_IDLE = 3000;
    private static final int MIN_TIME_SHOOT = 1000;
    private static final int MAX_TIME_SHOOT = 2000;
    private int state_time;
    private byte state;
    private static final byte STATE_IDLE = 1;
    private static final byte STATE_SHOOT = 2;
    private int speed_dx;
    private int speed_dz;
    private int initial_x;
    private int initial_z;
    private static Random rndm;

    public SCHeliEnemy(AEGraphNode base1, AEScene modul_root, int tx, int ty, int tz, int rx, int ry, int rz, int hitpoints, int hitradius, AEExplosionInterface explosion, SCWeaponSystem weapon, int[] target_count_array, int target_count_id, long tile) {
        if (rndm == null) {
            rndm = new Random();
        }
        this.base1 = base1;
        this.base1.stopAnim(0);
        this.base1.setRotation(0, -modul_root.getRotationY() + 2048, 0);
        int start_tx = 0;
        start_tx = rndm.nextInt(2) == 1 ? 4096 : -4096;
        this.base1.setTranslation(tx + start_tx, ty, tz);
        this.initial_hitpoints = this.hitpoints = hitpoints;
        this.hitradius = hitradius;
        this.explosion = explosion;
        if (explosion != null) {
            explosion.getParticleSystem().setTranslation(tx, ty, tz);
        }
        this.weapon = weapon;
        this.target_count_array = target_count_array;
        this.target_count_id = target_count_id;
        this.tile = tile;
        this.speed_dx = rndm.nextInt(4032) + 64;
        this.speed_dz = rndm.nextInt(4032) + 64;
        this.initial_x = tx;
        this.initial_z = tz;
        this.state = 1;
        this.state_time = 12000;
    }

    public void applyHitpoints(int hitpoints) {
        if (this.hitpoints <= 0) {
            return;
        }
        this.hitpoints += hitpoints;
        if (this.hitpoints <= 0) {
            AEGroup modul_root = this.base1.getParent();
            if (modul_root != null) {
                this.base1.playAnim((byte)1);
            }
            if (this.explosion != null) {
                this.explosion.getParticleSystem().setTranslation(this.base1.getPositionX(), this.base1.getPositionY(), this.base1.getPositionZ());
                this.explosion.start();
            }
            if (this.target_count_array != null) {
                int n = this.target_count_id;
                this.target_count_array[n] = this.target_count_array[n] + 1;
            }
            ++grh.hit_notify;
        }
    }

    public int getCurrentX() {
        return this.base1.getWorldPositionX();
    }

    public int getCurrentY() {
        return this.base1.getWorldPositionY();
    }

    public int getCurrentZ() {
        return this.base1.getWorldPositionZ();
    }

    public AEGraphNode getGeometry() {
        return this.base1;
    }

    public int getHitRadius() {
        return this.hitradius;
    }

    public int getHitpoints() {
        return this.hitpoints;
    }

    public boolean isDead() {
        return this.hitpoints <= 0 && (this.explosion == null || !this.explosion.isActive());
    }

    public void setEnemySet(SCEnemySet enemy_set) {
        this.enemy_set = enemy_set;
    }

    public void setHitpoints(int hitpoints) {
        this.hitpoints = hitpoints;
    }

    public void update(int elapsed_time) {
        if (this.isDead()) {
            this.enemy_set.removeEnemy(this);
            if (this.base1.getParent() != null) {
                this.base1.getParent().removeChild(this.base1);
            }
        }
        if (this.explosion != null && this.explosion.isActive()) {
            this.explosion.update(elapsed_time);
        }
        if (this.state == 1) {
            this.base1.translate(elapsed_time * this.speed_dx >> 12, 0, elapsed_time * this.speed_dz >> 12);
            if (this.speed_dx > 0 && this.base1.getPositionX() > this.initial_x + 1024) {
                this.speed_dx = -this.speed_dx;
            } else if (this.speed_dx < 0 && this.base1.getPositionX() < this.initial_x - 1024) {
                this.speed_dx = -this.speed_dx;
            }
            if (this.speed_dz > 0 && this.base1.getPositionZ() > this.initial_z + 1024) {
                this.speed_dz = -this.speed_dz;
            } else if (this.speed_dz < 0 && this.base1.getPositionZ() < this.initial_z - 1024) {
                this.speed_dz = -this.speed_dz;
            }
            if (this.state_time < 0) {
                this.state = (byte)2;
                this.state_time = rndm.nextInt(1000) + 1000;
            }
        } else {
            if (this.weapon != null && this.hitpoints > 0) {
                this.weapon.shoot(this.base1);
            }
            if (this.state_time < 0) {
                this.state = 1;
                this.state_time = rndm.nextInt(1000) + 2000;
            }
        }
        if (this.weapon != null) {
            this.weapon.update(elapsed_time);
        }
        this.state_time -= elapsed_time;
    }

    public AEGraphNode getExplosion() {
        return this.explosion != null ? this.explosion.getParticleSystem() : null;
    }

    public SCWeaponSystem getWeapon() {
        return this.weapon;
    }

    public void reinit(int tx, int ty, int tz, int rx, int ry, int rz, AEScene modul_root, long tile) {
        int start_tx = 0;
        start_tx = rndm.nextInt(2) == 1 ? 4096 : -4096;
        this.base1.setTranslation(tx + start_tx, ty, tz);
        this.base1.stopAnim(0);
        this.explosion = this.explosion;
        if (this.explosion != null) {
            this.explosion.getParticleSystem().setTranslation(tx, ty, tz);
        }
        this.hitpoints = this.initial_hitpoints;
        if (this.base1.getParent() != null) {
            this.base1.getParent().removeChild(this.base1);
        }
        if (this.explosion != null && this.explosion.getParticleSystem().getParent() != null) {
            this.explosion.getParticleSystem().getParent().removeChild(this.explosion.getParticleSystem());
        }
        this.tile = tile;
        if (this.weapon != null) {
            this.weapon.reinit();
        }
        this.speed_dx = rndm.nextInt(4032) + 64;
        this.speed_dz = rndm.nextInt(4032) + 64;
        this.initial_x = tx;
        this.initial_z = tz;
        this.state = 1;
        this.state_time = 12000;
    }

    public boolean isUsed() {
        return this.tile >= SCLevel.getCurrentTile() && this.tile < SCLevel.getCurrentTile() + (long)SCLevel.modul.length;
    }

    public boolean isHit(long x, long y, long z) {
        if (this.hitpoints <= 0) {
            return false;
        }
        int dx = (int)(x + SCLevel.global_tx - (long)this.base1.getWorldPositionX());
        int dz = (int)(z + SCLevel.global_tz - (long)this.base1.getWorldPositionZ());
        return dx <= this.hitradius && dx >= -this.hitradius && dz <= this.hitradius && dz >= -this.hitradius;
    }

    public int getEnemyClassId() {
        return this.target_count_id;
    }

    public void release() {
        if (this.base1 != null) {
            this.base1.release();
        }
        this.base1 = null;
        if (this.enemy_set != null) {
            this.enemy_set.removeAllEnemies();
        }
        this.enemy_set = null;
        if (this.explosion != null) {
            this.explosion.release();
        }
        this.explosion = null;
        if (this.weapon != null) {
            this.weapon.release();
        }
        this.weapon = null;
        this.target_count_array = null;
        rndm = null;
    }

    public int getInitialHitpoints() {
        return this.initial_hitpoints;
    }
}

