/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AERenderer;
import ScrollerGame.SCWeaponSystem;
import java.util.Random;

public class SCEnemyWeapon
extends SCWeaponSystem {
    private int burst_time;
    private int wait_time;
    private int min_burst_time;
    private int max_burst_time;
    private int min_wait_time;
    private int max_wait_time;
    private static Random rndm;
    private boolean burst;

    public SCEnemyWeapon(int count, int speed, int lifetime, int hitpoints, int fire_rate, int min_burst_time, int max_burst_time, int min_wait_time, int max_wait_time, AEGeometry geometry, AERenderer renderer) {
        this(count, speed, lifetime, hitpoints, fire_rate, min_burst_time, max_burst_time, min_wait_time, max_wait_time, geometry, renderer, null);
    }

    public SCEnemyWeapon(int count, int speed, int lifetime, int hitpoints, int fire_rate, int min_burst_time, int max_burst_time, int min_wait_time, int max_wait_time, AEGeometry geometry, AERenderer renderer, AEExplosionInterface hit_explosion) {
        super(count, speed, lifetime, hitpoints, fire_rate, geometry, renderer, hit_explosion);
        this.min_burst_time = min_burst_time;
        this.max_burst_time = max_burst_time;
        this.min_wait_time = min_wait_time;
        this.max_wait_time = max_wait_time;
        if (rndm == null) {
            rndm = new Random();
        }
        this.burst_time = rndm.nextInt(max_burst_time - min_burst_time) + min_burst_time;
        this.wait_time = rndm.nextInt(max_wait_time - min_wait_time) + min_wait_time;
        this.burst = true;
    }

    public void shoot(AEGraphNode node) {
        if (!this.burst) {
            return;
        }
        super.shoot(node);
    }

    public void update(int elapsed_time) {
        super.update(elapsed_time);
        if (this.burst) {
            this.burst_time -= elapsed_time;
            if (this.burst_time <= 0) {
                this.burst_time = rndm.nextInt(this.max_burst_time - this.min_burst_time) + this.min_burst_time;
                this.burst = false;
            }
        } else {
            this.wait_time -= elapsed_time;
            if (this.wait_time <= 0) {
                this.wait_time = rndm.nextInt(this.max_wait_time - this.min_wait_time) + this.min_wait_time;
                this.burst = true;
            }
        }
    }

    public void release() {
        super.release();
        rndm = null;
    }
}

