/*
 * Decompiled with CFR 0.152.
 */
package ScrollerGame;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEGroup;
import AbyssEngine.AEScene;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCEnemySet;
import ScrollerGame.SCLevel;
import ScrollerGame.SCWeaponSystem;
import contentHeliStrike.grh;

public class SCStaticEnemy
implements SCEnemy {
    protected AEGraphNode geometry;
    protected AEGraphNode destroyed_geometry;
    protected int hitpoints;
    private int initial_hitpoints;
    protected int hitradius;
    protected int corrected_hitradius_x;
    protected int corrected_hitradius_z;
    protected SCEnemySet enemy_set;
    protected AEExplosionInterface explosion;
    protected int[] target_count_array;
    protected int target_count_id;
    private long tile;

    public SCStaticEnemy(AEGraphNode geometry, AEGraphNode destroyed_geometry, int tx, int ty, int tz, int rx, int ry, int rz, int hitpoints, int hitradius, AEExplosionInterface explosion, int[] target_count_array, int target_count_id, long tile) {
        this.geometry = geometry;
        this.geometry.setTranslation(tx, ty, tz);
        this.geometry.setRotation(rx, ry, rz);
        this.destroyed_geometry = destroyed_geometry;
        if (destroyed_geometry != null) {
            this.destroyed_geometry.stopAnim(0);
            this.destroyed_geometry.setTranslation(tx, ty, tz);
            this.destroyed_geometry.setRotation(rx, ry, rz);
            this.geometry.playAnim((byte)2);
        } else {
            this.geometry.stopAnim(0);
        }
        this.initial_hitpoints = this.hitpoints = hitpoints;
        this.hitradius = hitradius;
        this.explosion = explosion;
        if (explosion != null) {
            explosion.getParticleSystem().setTranslation(tx, ty, tz);
        }
        this.target_count_array = target_count_array;
        this.target_count_id = target_count_id;
        this.tile = tile;
    }

    public SCStaticEnemy(AEGraphNode geometry, int tx, int ty, int tz, int rx, int ry, int rz, int hitpoints, int hitradius, AEExplosionInterface explosion, int[] target_count_array, int target_count_id, long tile) {
        this(geometry, null, tx, ty, tz, rx, ry, rz, hitpoints, hitradius, explosion, target_count_array, target_count_id, tile);
    }

    public void applyHitpoints(int hitpoints) {
        if (this.hitpoints <= 0) {
            return;
        }
        this.hitpoints += hitpoints;
        if (this.hitpoints <= 0) {
            AEGroup modul_root = this.geometry.getParent();
            if (modul_root != null) {
                if (this.destroyed_geometry != null) {
                    modul_root.removeChild(this.geometry);
                    modul_root.addChild(this.destroyed_geometry);
                    this.destroyed_geometry.playAnim((byte)1);
                } else {
                    this.geometry.playAnim((byte)1);
                }
            }
            if (this.explosion != null) {
                this.explosion.getParticleSystem().setTranslation(this.geometry.getPositionX(), this.geometry.getPositionY(), this.geometry.getPositionZ());
                this.explosion.start();
            }
            if (this.target_count_array != null) {
                int n = this.target_count_id;
                this.target_count_array[n] = this.target_count_array[n] + 1;
            }
            ++grh.hit_notify;
        }
    }

    public int getCurrentX() {
        if (this.destroyed_geometry != null && this.hitpoints <= 0) {
            return this.destroyed_geometry.getWorldPositionX();
        }
        return this.geometry.getWorldPositionX();
    }

    public int getCurrentY() {
        if (this.destroyed_geometry != null && this.hitpoints <= 0) {
            return this.destroyed_geometry.getWorldPositionY();
        }
        return this.geometry.getWorldPositionY();
    }

    public int getCurrentZ() {
        if (this.destroyed_geometry != null && this.hitpoints <= 0) {
            return this.destroyed_geometry.getWorldPositionZ();
        }
        return this.geometry.getWorldPositionZ();
    }

    public AEGraphNode getGeometry() {
        return this.geometry;
    }

    public int getHitRadius() {
        return this.hitradius;
    }

    public int getHitpoints() {
        return this.hitpoints;
    }

    public boolean isDead() {
        return this.hitpoints <= 0 && (this.explosion == null || !this.explosion.isActive());
    }

    public void setEnemySet(SCEnemySet enemy_set) {
        this.enemy_set = enemy_set;
    }

    public void setHitpoints(int hitpoints) {
        this.hitpoints = hitpoints;
    }

    public void update(int elapsed_time) {
        if (this.isDead()) {
            this.enemy_set.removeEnemy(this);
            if (this.geometry.getParent() != null) {
                this.geometry.getParent().removeChild(this.geometry);
            }
            if (this.explosion != null && this.explosion.getParticleSystem().getParent() != null) {
                this.explosion.getParticleSystem().getParent().removeChild(this.explosion.getParticleSystem());
            }
        }
        if (this.explosion != null && this.explosion.isActive()) {
            this.explosion.update(elapsed_time);
        }
        int dx = this.geometry.getWorldPositionX() - SCLevel.getCurrentX();
        int dz = this.geometry.getWorldPositionZ() - SCLevel.getCurrentZ();
        dx = dx < 0 ? -dx : dx;
        int n = dz = dz < 0 ? -dz : dz;
        if (dz > dx) {
            this.corrected_hitradius_z = this.hitradius - ((dz * (this.geometry.getWorldPositionY() - 700) >> 12) * 4096 >> 12);
            this.corrected_hitradius_x = this.hitradius;
        } else {
            this.corrected_hitradius_x = this.hitradius - ((dx * (this.geometry.getWorldPositionY() - 700) >> 12) * 4096 >> 12);
            this.corrected_hitradius_z = this.hitradius;
        }
    }

    public AEGraphNode getExplosion() {
        return this.explosion != null ? this.explosion.getParticleSystem() : null;
    }

    public SCWeaponSystem getWeapon() {
        return null;
    }

    public void reinit(int tx, int ty, int tz, int rx, int ry, int rz, AEScene modul_root, long tile) {
        this.geometry.setTranslation(tx, ty, tz);
        this.geometry.setRotation(rx, ry, rz);
        if (this.destroyed_geometry != null) {
            this.destroyed_geometry.stopAnim(0);
            this.destroyed_geometry.setTranslation(tx, ty, tz);
            this.destroyed_geometry.setRotation(rx, ry, rz);
            this.geometry.playAnim((byte)2);
        } else {
            this.geometry.stopAnim(0);
        }
        if (this.explosion != null) {
            this.explosion.getParticleSystem().setTranslation(tx, ty, tz);
        }
        this.hitpoints = this.initial_hitpoints;
        if (this.geometry.getParent() != null) {
            this.geometry.getParent().removeChild(this.geometry);
        }
        if (this.destroyed_geometry != null && this.destroyed_geometry.getParent() != null) {
            this.destroyed_geometry.getParent().removeChild(this.destroyed_geometry);
        }
        if (this.explosion != null && this.explosion.getParticleSystem().getParent() != null) {
            this.explosion.getParticleSystem().getParent().removeChild(this.explosion.getParticleSystem());
        }
        this.tile = tile;
    }

    public boolean isUsed() {
        return this.tile >= SCLevel.getCurrentTile() && this.tile < SCLevel.getCurrentTile() + (long)SCLevel.modul.length;
    }

    public boolean isHit(long x, long y, long z) {
        if (this.hitpoints <= 0) {
            return false;
        }
        int dx = (int)(x + SCLevel.global_tx - (long)this.geometry.getWorldPositionX());
        int dz = (int)(z + SCLevel.global_tz - (long)this.geometry.getWorldPositionZ());
        return dx <= this.corrected_hitradius_x && dx >= -this.corrected_hitradius_x && dz <= this.corrected_hitradius_z && dz >= -this.corrected_hitradius_z;
    }

    public int getEnemyClassId() {
        return this.target_count_id;
    }

    public int getInitialHitpoints() {
        return this.initial_hitpoints;
    }

    public void release() {
        if (this.geometry.getParent() != null) {
            this.geometry.getParent().removeChild(this.geometry);
        }
        if (this.destroyed_geometry != null && this.destroyed_geometry.getParent() != null) {
            this.destroyed_geometry.getParent().removeChild(this.destroyed_geometry);
        }
        if (this.explosion != null && this.explosion.getParticleSystem().getParent() != null) {
            this.explosion.getParticleSystem().getParent().removeChild(this.explosion.getParticleSystem());
        }
        if (this.geometry != null) {
            this.geometry.release();
        }
        this.geometry = null;
        if (this.destroyed_geometry != null) {
            this.destroyed_geometry.release();
        }
        this.destroyed_geometry = null;
        this.enemy_set = null;
        if (this.explosion != null) {
            this.explosion.release();
        }
        this.explosion = null;
        this.target_count_array = null;
    }
}

