/*
 * Decompiled with CFR 0.152.
 */
package AppKit;

import AppKit.AEMenuBackground;
import AppKit.AEMenuButton;
import AppKit.AEMenuButtonLayout;

public class AEMenuPage {
    protected static final byte STATE_INIT = 0;
    protected static final byte STATE_FADE_IN = 1;
    protected static final byte STATE_FADE_OUT = 2;
    protected static final byte STATE_NORMAL = 3;
    protected static final byte ACTION_DO_NOTHING = 0;
    protected static final byte ACTION_MENUBUTTON = 1;
    protected static final byte ACTION_LSOFTBUTTON = 2;
    protected static final byte ACTION_RSOFTBUTTON = 3;
    protected byte state = 0;
    protected byte action = 0;
    public AEMenuButtonLayout button_layout;
    public AEMenuButton soft_button_left;
    public AEMenuButton soft_button_right;
    protected AEMenuBackground background;
    protected boolean forceFadeOut;

    public AEMenuButton[] getButtons() {
        if (this.button_layout != null) {
            return this.button_layout.button;
        }
        return null;
    }

    public void setButtonLayout(AEMenuButtonLayout layout) {
        this.button_layout = layout;
    }

    public void setBackground(AEMenuBackground background) {
        this.background = background;
    }

    public void setLeftSoftButton(AEMenuButton button) {
        this.soft_button_left = button;
    }

    public void setRightSoftButton(AEMenuButton button) {
        this.soft_button_right = button;
    }

    public void selectNextButton() {
        if (this.button_layout == null) {
            return;
        }
        if (this.state == 1 || this.state == 2) {
            this.forceFadeIn();
        }
        if (this.state == 3) {
            this.button_layout.selectNextButton();
        }
    }

    public void selectPrevButton() {
        if (this.button_layout == null) {
            return;
        }
        if (this.state == 1 || this.state == 2) {
            this.forceFadeIn();
        }
        if (this.state == 3) {
            this.button_layout.selectPrevButton();
        }
    }

    public void pressButton() {
        if (this.state == 1 || this.state == 2) {
            this.forceFadeIn();
        } else if (this.state == 3 && this.button_layout != null && this.button_layout.currentButton() != null && this.button_layout.currentButton().isActive()) {
            this.state = (byte)2;
            this.action = 1;
        }
    }

    public void pressLeftSoftButton() {
        if (this.state == 1 || this.state == 2) {
            this.forceFadeIn();
        } else if (this.state == 3 && this.soft_button_left != null && this.soft_button_left.isActive()) {
            this.state = (byte)2;
            this.action = (byte)2;
        }
    }

    public void pressRightSoftButton() {
        if (this.soft_button_right != null && this.soft_button_right.isActive()) {
            this.state = (byte)2;
            this.action = (byte)3;
        } else if (this.state == 1 || this.state == 2) {
            this.forceFadeIn();
        }
    }

    public boolean fadeIn() {
        boolean result = true;
        if (this.background != null) {
            boolean bl = result = result && this.background.fadeIn();
        }
        if (this.button_layout != null) {
            boolean bl = result = result && this.button_layout.fadeIn();
        }
        if (this.soft_button_left != null) {
            boolean bl = result = result && this.soft_button_left.fadeIn();
        }
        if (this.soft_button_right != null) {
            result = result && this.soft_button_right.fadeIn();
        }
        return result;
    }

    public boolean fadeOut() {
        if (this.forceFadeOut) {
            return true;
        }
        boolean result = true;
        if (this.background != null) {
            boolean bl = result = result && this.background.fadeOut();
        }
        if (this.button_layout != null) {
            boolean bl = result = result && this.button_layout.fadeOut();
        }
        if (this.soft_button_left != null) {
            boolean bl = result = result && this.soft_button_left.fadeOut();
        }
        if (this.soft_button_right != null) {
            result = result && this.soft_button_right.fadeOut();
        }
        return result;
    }

    public void draw() {
        switch (this.state) {
            case 0: {
                if (this.background != null) {
                    this.background.init();
                }
                if (this.button_layout != null) {
                    this.button_layout.init();
                }
                if (this.soft_button_left != null) {
                    this.soft_button_left.init();
                }
                if (this.soft_button_right != null) {
                    this.soft_button_right.init();
                }
                this.state = 1;
            }
            case 1: {
                if (!this.fadeIn()) break;
                this.state = (byte)3;
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                if (!this.fadeOut()) break;
                if (this.action == 1 && this.button_layout != null) {
                    this.button_layout.pressButton();
                }
                if (this.action == 2 && this.soft_button_left != null) {
                    this.soft_button_left.press();
                }
                if (this.action == 3 && this.soft_button_right != null) {
                    this.soft_button_right.press();
                }
                this.init();
            }
        }
        if (this.background != null) {
            this.background.draw();
        }
        if (this.button_layout != null) {
            this.button_layout.draw();
        }
        if (this.soft_button_left != null) {
            this.soft_button_left.draw();
        }
        if (this.soft_button_right != null) {
            this.soft_button_right.draw();
        }
    }

    public void init() {
        this.state = 0;
        this.action = 0;
        this.forceFadeOut = false;
    }

    public void forceFadeIn() {
        if (this.state == 1) {
            if (this.background != null) {
                this.background.forceFadeIn();
            }
            if (this.button_layout != null) {
                this.button_layout.forceFadeIn();
            }
            if (this.soft_button_left != null) {
                this.soft_button_left.forceFadeIn();
            }
            if (this.soft_button_right != null) {
                this.soft_button_right.forceFadeIn();
            }
        } else if (this.state == 2) {
            this.forceFadeOut = true;
        }
    }

    public void release() {
        if (this.button_layout != null) {
            this.button_layout.release();
            this.button_layout = null;
        }
        if (this.soft_button_left != null) {
            this.soft_button_left.release();
            this.soft_button_left = null;
        }
        if (this.soft_button_right != null) {
            this.soft_button_right.release();
            this.soft_button_right = null;
        }
        if (this.background != null) {
            this.background.release();
            this.background = null;
        }
    }
}

