/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEBoundingSphere;
import AbyssEngine.AELeafNode;
import AbyssEngine.AEMath;
import AbyssEngine.AERenderer;
import AbyssEngine.AETransform;
import AbyssEngine.AEVector3D;
import AbyssEngine.JSRCamera;

public abstract class AECamera
extends AELeafNode {
    protected int fov;
    protected int near;
    protected int far;
    protected AEVector3D[] frustum_normal = new AEVector3D[6];
    protected AEVector3D[] trans_frustum_normal = new AEVector3D[6];
    protected int[] d;
    protected static AEVector3D tmp_vec1 = new AEVector3D();
    protected static AEVector3D tmp_vec2 = new AEVector3D();
    protected static AEVector3D tmp_vec3 = new AEVector3D();
    protected int dWidth;
    protected int dHeight;
    protected int ffactor1;
    protected int ffactor2;
    private static final short F_NEAR = 0;
    private static final short F_FAR = 1;
    private static final short F_LEFT = 2;
    private static final short F_RIGHT = 3;
    private static final short F_TOP = 4;
    private static final short F_BOTTOM = 5;

    protected AECamera(int dWidth, int dHeight, int fov, int near, int far) {
        for (int i = this.trans_frustum_normal.length - 1; i >= 0; --i) {
            this.trans_frustum_normal[i] = new AEVector3D();
        }
        this.d = new int[6];
        this.frustum_normal[0] = new AEVector3D(0, 0, -4096);
        this.frustum_normal[1] = new AEVector3D(0, 0, 4096);
        this.frustum_normal[2] = new AEVector3D();
        this.frustum_normal[3] = new AEVector3D();
        this.frustum_normal[4] = new AEVector3D();
        this.frustum_normal[5] = new AEVector3D();
        this.dWidth = dWidth;
        this.dHeight = dHeight;
        this.setPerspective(fov, near, far);
    }

    protected AECamera(int dWidth, int dHeight) {
        this(dWidth, dHeight, 1024, 10, 8192);
    }

    public void update(boolean transformUpdate) {
        if (this.transformUpdate || transformUpdate) {
            if (this.parent != null) {
                this.world = this.parent.world.multiply(this.local, this.world);
            } else {
                this.world.set(this.local);
            }
            this.trans_frustum_normal = this.world.getRotated(this.frustum_normal, this.trans_frustum_normal);
            tmp_vec1 = this.world.getPosition(tmp_vec1);
            tmp_vec2 = this.world.getDirection(tmp_vec2);
            tmp_vec3.set(tmp_vec2);
            tmp_vec2.mul(-this.near);
            tmp_vec3.mul(-this.far);
            tmp_vec2.add(tmp_vec1);
            tmp_vec3.add(tmp_vec1);
            this.d[0] = tmp_vec2.dot(this.trans_frustum_normal[0]);
            this.d[1] = tmp_vec3.dot(this.trans_frustum_normal[1]);
            this.d[2] = tmp_vec1.dot(this.trans_frustum_normal[2]);
            this.d[3] = tmp_vec1.dot(this.trans_frustum_normal[3]);
            this.d[4] = tmp_vec1.dot(this.trans_frustum_normal[4]);
            this.d[5] = tmp_vec1.dot(this.trans_frustum_normal[5]);
            this.transformUpdate = false;
            this.pathUpdate = false;
        }
    }

    public void setPerspective(int fov, int near, int far) {
        this.fov = fov;
        this.near = near;
        this.far = far;
        int fsin = AEMath.sin(fov >> 1);
        int fcos = AEMath.cos(fov >> 1);
        this.frustum_normal[2].set(fcos, 0, -fsin);
        this.frustum_normal[3].set(-fcos, 0, -fsin);
        this.frustum_normal[4].set(0, -fcos, -fsin);
        this.frustum_normal[5].set(0, fcos, -fsin);
        this.ffactor1 = (fsin << 12) / fcos;
        this.ffactor2 = this.ffactor1 * ((this.dWidth << 12) / this.dHeight) >> 12;
    }

    public void setFov(int fov) {
        this.setPerspective(fov, this.near, this.far);
    }

    public int getFov() {
        return this.fov;
    }

    public boolean getScreenPosition(AEVector3D pos) {
        pos = this.world.inverseTransform(pos);
        if (pos.z > this.near) {
            return false;
        }
        int div1 = this.ffactor2 * pos.z >> 12;
        int div2 = this.ffactor1 * pos.z >> 12;
        if (div1 == 0 || div2 == 0) {
            return false;
        }
        pos.x = -((pos.x << 11) / div1 * this.dWidth >> 12) + (this.dWidth >> 1);
        pos.y = ((pos.y << 11) / div2 * this.dHeight >> 12) + (this.dHeight >> 1);
        return pos.x >= 0 && pos.y >= 0 && pos.x < this.dWidth && pos.y < this.dHeight;
    }

    public void setClippingPlanes(int near, int far) {
        this.setPerspective(this.fov, near, far);
    }

    public boolean isInFrustum(AEBoundingSphere bs) {
        for (int i = 5; i >= 0; --i) {
            if (bs.pos.dot(this.trans_frustum_normal[i]) - this.d[i] >= -bs.r) continue;
            return false;
        }
        return true;
    }

    public void prerender(AECamera camera, AERenderer renderer) {
    }

    public abstract void setCamera();

    public AETransform getViewMatrix(AETransform result) {
        result = this.world.getInverse(result);
        return result;
    }

    public AETransform getViewMatrix() {
        return this.world.getInverse();
    }

    public static AECamera create(int dWidth, int dHeight, int fov, int near, int far) {
        return new JSRCamera(dWidth, dHeight, fov, near, far);
    }

    public static AECamera create(int dWidth, int dHeight) {
        return new JSRCamera(dWidth, dHeight);
    }

    public void release() {
        super.release();
        this.frustum_normal = null;
        this.trans_frustum_normal = null;
        this.d = null;
    }
}

