/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AEGeometry;
import AbyssEngine.AEParticleAccess;
import AbyssEngine.AEResourceManager;
import ScrollerGame.SCLevel;
import contentHeliStrike.grh;
import java.util.Random;

public class SCSmokeTrail {
    private long[] ppos;
    private AEGeometry smoke = AEGeometry.createParticleSystem(128, 47, 0, 95, 47, 24, 40, (byte)1);
    private int current_smoke_id;
    private int[] smoke_rndm;
    private static final int SMOKE_COUNT = 40;
    private static final int SMOKE_SIZE = 24;
    private boolean stop_emitter;
    private boolean active;
    private int stop_emitter_id;

    public SCSmokeTrail() {
        int i;
        this.smoke.setLayer(1);
        this.smoke.setTexture(AEResourceManager.getTextureResource(2));
        this.current_smoke_id = 0;
        this.smoke_rndm = new int[40];
        Random rndm = new Random();
        for (i = 0; i < this.smoke_rndm.length; ++i) {
            this.smoke_rndm[i] = rndm.nextInt(2) + 1;
        }
        this.ppos = new long[120];
        for (i = 0; i < this.ppos.length; ++i) {
            this.ppos[i] = 32767L;
        }
        this.stop_emitter = true;
        this.active = false;
    }

    public void reinit() {
        for (int i = 0; i < this.ppos.length; ++i) {
            this.ppos[i] = 32767L;
        }
    }

    public void emit(long x, long y, long z) {
        this.ppos[this.current_smoke_id] = x;
        this.ppos[this.current_smoke_id + 1] = y;
        this.ppos[this.current_smoke_id + 2] = z;
        this.current_smoke_id += 3;
        if (this.current_smoke_id >= this.ppos.length) {
            this.current_smoke_id = 0;
        }
        this.active = true;
        this.stop_emitter = false;
        this.stop_emitter_id = this.current_smoke_id;
    }

    public void render() {
        if (!this.active) {
            return;
        }
        int[] smoke_pos = ((AEParticleAccess)((Object)this.smoke)).getPositions();
        for (int i = 0; i < smoke_pos.length; i += 3) {
            smoke_pos[i] = (int)(this.ppos[i] + SCLevel.global_tx);
            smoke_pos[i + 1] = (int)this.ppos[i + 1];
            smoke_pos[i + 2] = (int)(this.ppos[i + 2] + SCLevel.global_tz);
        }
        int[] smoke_size = ((AEParticleAccess)((Object)this.smoke)).getSizes();
        smoke_size[this.current_smoke_id / 3] = 24;
        for (int i = 0; i < smoke_size.length; ++i) {
            int n = i;
            smoke_size[n] = smoke_size[n] + this.smoke_rndm[i];
        }
        int[] smoke_color = ((AEParticleAccess)((Object)this.smoke)).getColors();
        int id = this.current_smoke_id / 3;
        for (int c = 0; c < smoke_color.length; ++c) {
            int alpha = 255 * c / smoke_color.length;
            smoke_color[id] = alpha << 24 | 0xFFFFFF;
            if (++id < smoke_color.length) continue;
            id = 0;
        }
        grh.r_renderer.render(this.smoke);
        if (this.stop_emitter) {
            this.ppos[this.current_smoke_id] = 32767L;
            this.ppos[this.current_smoke_id + 1] = 32767L;
            this.ppos[this.current_smoke_id + 2] = 32767L;
            this.current_smoke_id += 3;
            if (this.current_smoke_id >= this.ppos.length) {
                this.current_smoke_id = 0;
            }
            if (this.current_smoke_id == this.stop_emitter_id) {
                this.active = false;
            }
        }
        this.stop_emitter = true;
    }

    public void release() {
        this.ppos = null;
        if (this.smoke != null) {
            this.smoke.release();
        }
        this.smoke = null;
        this.smoke_rndm = null;
    }
}

