/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEGroup;
import AbyssEngine.AEScene;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCEnemySet;
import ScrollerGame.SCLevel;
import ScrollerGame.SCPlayer;
import ScrollerGame.SCWeaponSystem;
import contentHeliStrike.HeliStrikeCamera_2;
import contentHeliStrike.MainGame;
import contentHeliStrike.grh;

public class SCPowerUp
implements SCEnemy {
    public static final byte TYPE_WEAPON = 1;
    public static final byte TYPE_HEALTH = 2;
    public static final byte TYPE_SHIELD = 3;
    public static final byte TYPE_NUKE = 4;
    public static final int HEALTH_HITPOINTS = 80;
    protected AEGraphNode geometry;
    private int hitradius;
    protected SCEnemySet enemy_set;
    protected AEExplosionInterface explosion;
    private long tile;
    private boolean isDead;
    private byte type;

    public SCPowerUp(AEGraphNode geometry, int tx, int ty, int tz, int rx, int ry, int rz, int hitradius, AEExplosionInterface explosion, byte type, long tile) {
        this.geometry = geometry;
        this.geometry.setTranslation(tx, ty, tz);
        this.geometry.setRotation(rx, ry, rz);
        this.geometry.playAnim((byte)2);
        this.hitradius = hitradius;
        this.explosion = explosion;
        if (explosion != null) {
            explosion.getParticleSystem().setTranslation(tx, ty, tz);
        }
        this.type = type;
        this.tile = tile;
        this.isDead = false;
    }

    public void applyHitpoints(int hitpoints) {
        if (hitpoints == -1000000 && !this.isDead) {
            AEGroup modul_root = this.geometry.getParent();
            if (modul_root != null) {
                modul_root.removeChild(this.geometry);
                switch (this.type) {
                    case 1: {
                        switch (SCLevel.getWeapon().getShootMode()) {
                            case 0: {
                                SCLevel.getWeapon().setShootMode((byte)1);
                                ((MainGame)grh.r_modul[2]).setPowerUp((byte)1);
                                break;
                            }
                            case 1: {
                                SCLevel.getWeapon().setShootMode((byte)2);
                                ((MainGame)grh.r_modul[2]).setPowerUp((byte)2);
                                break;
                            }
                            case 2: {
                                SCLevel.getWeapon().setShootMode((byte)3);
                                ((MainGame)grh.r_modul[2]).setPowerUp((byte)3);
                                break;
                            }
                            case 3: {
                                SCLevel.getWeapon().setShootMode((byte)4);
                                ((MainGame)grh.r_modul[2]).setPowerUp((byte)4);
                            }
                        }
                        break;
                    }
                    case 2: {
                        SCPlayer cfr_ignored_0 = (SCPlayer)SCLevel.getPlayer();
                        if (SCPlayer.HITPOINTS > SCLevel.getPlayer().getHitpoints() + 80) {
                            SCLevel.getPlayer().applyHitpoints(80);
                        } else {
                            SCPlayer cfr_ignored_1 = (SCPlayer)SCLevel.getPlayer();
                            SCLevel.getPlayer().setHitpoints(SCPlayer.HITPOINTS);
                        }
                        ((MainGame)grh.r_modul[2]).setPowerUp((byte)5);
                        break;
                    }
                    case 3: {
                        ((HeliStrikeCamera_2)SCLevel.cm).enableShield();
                        ((MainGame)grh.r_modul[2]).setPowerUp((byte)6);
                        break;
                    }
                    case 4: {
                        ((MainGame)grh.r_modul[2]).setPowerUp((byte)7);
                    }
                }
            }
            if (this.explosion != null) {
                this.explosion.getParticleSystem().setTranslation(this.geometry.getPositionX(), this.geometry.getPositionY(), this.geometry.getPositionZ());
                this.explosion.start();
            }
            this.isDead = true;
        }
    }

    public int getCurrentX() {
        return this.geometry.getWorldPositionX();
    }

    public int getCurrentY() {
        return this.geometry.getWorldPositionY();
    }

    public int getCurrentZ() {
        return this.geometry.getWorldPositionZ();
    }

    public AEGraphNode getGeometry() {
        return this.geometry;
    }

    public int getHitRadius() {
        return this.hitradius;
    }

    public int getHitpoints() {
        return 10;
    }

    public boolean isDead() {
        return this.isDead && (this.explosion == null || !this.explosion.isActive());
    }

    public void setEnemySet(SCEnemySet enemy_set) {
        this.enemy_set = enemy_set;
    }

    public void setHitpoints(int hitpoints) {
    }

    public void update(int elapsed_time) {
        if (this.isDead()) {
            this.enemy_set.removeEnemy(this);
            if (this.geometry.getParent() != null) {
                this.geometry.getParent().removeChild(this.geometry);
            }
            if (this.explosion != null && this.explosion.getParticleSystem().getParent() != null) {
                this.explosion.getParticleSystem().getParent().removeChild(this.explosion.getParticleSystem());
            }
        }
        if (this.explosion != null && this.explosion.isActive()) {
            this.explosion.update(elapsed_time);
        }
    }

    public AEGraphNode getExplosion() {
        return this.explosion != null ? this.explosion.getParticleSystem() : null;
    }

    public SCWeaponSystem getWeapon() {
        return null;
    }

    public void reinit(int tx, int ty, int tz, int rx, int ry, int rz, AEScene modul_root, long tile) {
        this.geometry.setTranslation(tx, ty, tz);
        this.geometry.setRotation(rx, ry, rz);
        this.geometry.playAnim((byte)2);
        if (this.explosion != null) {
            this.explosion.getParticleSystem().setTranslation(tx, ty, tz);
        }
        if (this.geometry.getParent() != null) {
            this.geometry.getParent().removeChild(this.geometry);
        }
        if (this.explosion != null && this.explosion.getParticleSystem().getParent() != null) {
            this.explosion.getParticleSystem().getParent().removeChild(this.explosion.getParticleSystem());
        }
        this.tile = tile;
        this.isDead = false;
    }

    public boolean isUsed() {
        return this.tile >= SCLevel.getCurrentTile() && this.tile < SCLevel.getCurrentTile() + (long)SCLevel.modul.length;
    }

    public boolean isHit(long x, long y, long z) {
        if (this.isDead) {
            return false;
        }
        int dx = (int)(x + SCLevel.global_tx - (long)this.geometry.getWorldPositionX());
        int dz = (int)(z + SCLevel.global_tz - (long)this.geometry.getWorldPositionZ());
        return dx <= this.hitradius && dx >= -this.hitradius && dz <= this.hitradius && dz >= -this.hitradius;
    }

    public int getEnemyClassId() {
        return 10;
    }

    public void release() {
        if (this.geometry != null) {
            this.geometry.release();
        }
        this.geometry = null;
        if (this.enemy_set != null) {
            this.enemy_set.removeAllEnemies();
        }
        this.enemy_set = null;
        if (this.explosion != null) {
            this.explosion.release();
        }
        this.explosion = null;
    }

    public int getInitialHitpoints() {
        return 0;
    }
}

