/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEParticleAccess;
import AbyssEngine.AERenderer;
import AbyssEngine.AEResourceManager;
import AbyssEngine.AEVector3D;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCLevel;
import ScrollerGame.SCWeaponSystem;
import contentHeliStrike.SCSmokeTrail;

public class SCHeliRocket
extends SCWeaponSystem {
    private AEGraphNode target;
    private static AEVector3D tmp1;
    private long aim_time;
    private static final long AIM_TIME = 500L;
    private SCSmokeTrail[] smoke;

    public SCHeliRocket(int count, int speed, int lifetime, int hitpoints, int fire_rate, AEGeometry geometry, AERenderer renderer, AEExplosionInterface hit_explosion) {
        super(count, speed, lifetime, hitpoints, fire_rate, geometry, renderer, hit_explosion);
        this.smoke = new SCSmokeTrail[count];
        for (int i = 0; i < this.smoke.length; ++i) {
            this.smoke[i] = new SCSmokeTrail();
        }
    }

    public static SCHeliRocket create(int count, int speed, int lifetime, int hitpoints, int fire_rate, int size, AERenderer renderer, AEExplosionInterface hit_explosion) {
        AEGeometry particle_system = AEGeometry.createParticleSystem(128, 0, 0, 47, 47, size, count, (byte)1);
        particle_system.setLayer(1);
        particle_system.setTexture(AEResourceManager.getTextureResource(2));
        if (tmp1 == null) {
            tmp1 = new AEVector3D();
        }
        return new SCHeliRocket(count, speed, lifetime, hitpoints, fire_rate, particle_system, renderer, hit_explosion);
    }

    public void reinit() {
        super.reinit();
        for (int i = 0; i < this.smoke.length; ++i) {
            this.smoke[i].reinit();
        }
    }

    public void update(int elapsed_time) {
        this.aim_time -= (long)elapsed_time;
        if (this.isActive) {
            int tspeed = elapsed_time * this.speed >> 12;
            int s = 0;
            int i = 0;
            while (i < this.ppos.length) {
                if (this.pactive[s] > 0) {
                    int n = s;
                    this.pactive[n] = this.pactive[n] - elapsed_time;
                    if (this.target == null) {
                        int n2 = i;
                        this.ppos[n2] = this.ppos[n2] + (long)(this.pdir[i] * tspeed >> 12);
                        int n3 = i + 1;
                        this.ppos[n3] = this.ppos[n3] + (long)(this.pdir[i + 1] * tspeed >> 12);
                        int n4 = i + 2;
                        this.ppos[n4] = this.ppos[n4] + (long)(this.pdir[i + 2] * tspeed >> 12);
                    } else {
                        int n5 = i;
                        this.ppos[n5] = this.ppos[n5] + (long)(this.pdir[i] * tspeed >> 12);
                        int n6 = i + 1;
                        this.ppos[n6] = this.ppos[n6] + (long)(this.pdir[i + 1] * tspeed >> 12);
                        int n7 = i + 2;
                        this.ppos[n7] = this.ppos[n7] + (long)(this.pdir[i + 2] * tspeed >> 12);
                        if (this.aim_time <= 0L) {
                            tmp1.set(-((int)(this.ppos[i] + SCLevel.global_tx)) + this.target.getWorldPositionX(), -((int)this.ppos[i + 1]) + this.target.getWorldPositionY(), -((int)(this.ppos[i + 2] + SCLevel.global_tz)) + this.target.getWorldPositionZ());
                            tmp1.normalize();
                            SCHeliRocket.tmp1.x = (SCHeliRocket.tmp1.x * 1024 >> 12) + (this.pdir[i] * 3072 >> 12);
                            SCHeliRocket.tmp1.y = (SCHeliRocket.tmp1.y * 1024 >> 12) + (this.pdir[i + 1] * 3072 >> 12);
                            SCHeliRocket.tmp1.z = (SCHeliRocket.tmp1.z * 1024 >> 12) + (this.pdir[i + 2] * 3072 >> 12);
                            tmp1.normalize();
                            this.pdir[i] = SCHeliRocket.tmp1.x;
                            this.pdir[i + 1] = SCHeliRocket.tmp1.y;
                            this.pdir[i + 2] = SCHeliRocket.tmp1.z;
                        }
                    }
                    this.smoke[i / 3].emit(this.ppos[i], this.ppos[i + 1], this.ppos[i + 2]);
                } else {
                    this.ppos[i + 2] = Integer.MAX_VALUE;
                    this.ppos[i + 1] = Integer.MAX_VALUE;
                    this.ppos[i] = Integer.MAX_VALUE;
                }
                i += 3;
                ++s;
            }
            this.clifetime -= elapsed_time;
            if (this.clifetime < 0 && this.isActive) {
                this.isActive = false;
                for (i = 0; i < this.ppos.length; ++i) {
                    this.ppos[i] = 32767L;
                }
                if (this.hit_explosion != null) {
                    this.hit_x = this.ppos[0];
                    this.hit_y = this.ppos[1];
                    this.hit_z = this.ppos[2];
                    this.hit_explosion.getParticleSystem().setTranslation((int)(this.hit_x + SCLevel.global_tx), (int)this.hit_y, (int)(this.hit_z + SCLevel.global_tz));
                    this.hit_explosion.start();
                }
            }
            if (this.enemy_set != null && !this.enemy_set.isEmpty()) {
                for (int e = 0; e < this.enemy_set.getEnemies().length; ++e) {
                    SCEnemy enemy = this.enemy_set.getEnemies()[e];
                    s = 0;
                    int i2 = 0;
                    while (i2 < this.ppos.length) {
                        if (this.pactive[s] > 0 && enemy.isHit(this.ppos[i2], this.ppos[i2 + 1], this.ppos[i2 + 2])) {
                            enemy.applyHitpoints(-this.hitpoints);
                            this.pactive[s] = -1;
                            if (this.hit_explosion != null) {
                                this.hit_x = this.ppos[i2];
                                this.hit_y = this.ppos[i2 + 1];
                                this.hit_z = this.ppos[i2 + 2];
                                this.hit_explosion.getParticleSystem().setTranslation((int)(this.hit_x + SCLevel.global_tx), (int)this.hit_y, (int)(this.hit_z + SCLevel.global_tz));
                                this.hit_explosion.start();
                            }
                        }
                        i2 += 3;
                        ++s;
                    }
                }
            }
        }
        if (this.shoot_delay > 0) {
            this.shoot_delay -= elapsed_time;
        }
        if (this.hit_explosion != null && this.hit_explosion.isActive()) {
            this.hit_explosion.getParticleSystem().setTranslation((int)(this.hit_x + SCLevel.global_tx), (int)this.hit_y, (int)(this.hit_z + SCLevel.global_tz));
            this.hit_explosion.update(elapsed_time);
        }
    }

    public void setTarget(AEGraphNode target) {
        this.target = target;
    }

    public void shoot(AEGraphNode node) {
        if (this.shoot_delay <= 0) {
            int target_dx = node.getWorldPositionX() - SCLevel.getCurrentX();
            int target_dz = node.getWorldPositionZ() - SCLevel.getCurrentZ();
            target_dx = target_dx < 0 ? -target_dx : target_dx;
            int n = target_dz = target_dz < 0 ? -target_dz : target_dz;
            if (target_dx > 7000 || target_dz > 7000) {
                return;
            }
            this.isActive = true;
            this.clifetime = this.lifetime;
            this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
            this.pdir[this.next_indx] = -node.getWorldDirectionX();
            this.ppos[this.next_indx + 1] = node.getWorldPositionY();
            this.pdir[this.next_indx + 1] = -node.getWorldDirectionY();
            this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
            this.pdir[this.next_indx + 2] = -node.getWorldDirectionZ();
            if (this.mode == 1) {
                this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
            }
            this.pactive[this.next_indx / 3] = this.lifetime;
            this.smoke[this.next_indx / 3].reinit();
            this.next_indx += 3;
            this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
            this.shoot_delay = this.fire_rate;
        }
        if (this.aim_time < 0L) {
            this.aim_time = 500L;
        }
    }

    public void render() {
        if (this.isActive) {
            switch (this.mode) {
                case 0: {
                    int i;
                    int[] pos = ((AEParticleAccess)((Object)this.geometry)).getPositions();
                    for (i = 0; i < this.ppos.length; i += 3) {
                        pos[i] = (int)(this.ppos[i] + SCLevel.global_tx);
                        pos[i + 1] = (int)this.ppos[i + 1];
                        pos[i + 2] = (int)(this.ppos[i + 2] + SCLevel.global_tz);
                    }
                    this.renderer.render(this.geometry);
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < this.ppos.length; i += 3) {
                        this.geometry_copy[i / 3].setTranslation((int)(this.ppos[i] + SCLevel.global_tx), (int)this.ppos[i + 1], (int)(this.ppos[i + 2] + SCLevel.global_tz));
                        this.renderer.render(this.geometry_copy[i / 3]);
                    }
                    break;
                }
            }
        }
        for (int i = 0; i < this.smoke.length; ++i) {
            this.smoke[i].render();
        }
        if (this.hit_explosion != null && this.hit_explosion.isActive()) {
            this.renderer.render(this.hit_explosion.getParticleSystem());
        }
    }

    public void release() {
        super.release();
        tmp1 = null;
        for (int i = 0; this.smoke != null && i < this.smoke.length; ++i) {
            this.smoke[i].release();
            this.smoke[i] = null;
        }
        this.smoke = null;
    }
}

