/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEGroup;
import AbyssEngine.AEScene;
import AbyssEngine.AEVector3D;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCEnemySet;
import ScrollerGame.SCLevel;
import ScrollerGame.SCWeaponSystem;
import java.util.Random;

public class SCBoatBossEnemy
implements SCEnemy {
    private AEGraphNode base1;
    private AEGraphNode destroyed;
    private AEGroup base_root = new AEGroup();
    private AEGroup shoot_node = new AEGroup();
    private int hitpoints;
    private int initial_hitpoints;
    private int hitradius;
    private int corrected_hitradius_x;
    private int corrected_hitradius_z;
    private SCEnemySet enemy_set;
    private AEExplosionInterface explosion;
    private SCWeaponSystem[] weapon;
    private int[] target_count_array;
    private int target_count_id;
    private long tile;
    private int time;
    private static final int MAX_DX = 2048;
    private static final int MAX_DZ = 1024;
    private static final int SPEED = 2048;
    private int initial_x;
    private int initial_z;
    private int target_x;
    private int target_z;
    private AEVector3D dir;
    private AEVector3D up;
    private AEVector3D left;
    private static Random rndm;
    public static boolean canShoot;
    private static final long INITIAL_SHOOT_DELAY = 3000L;
    private long initial_shoot_delay;

    public SCBoatBossEnemy(AEGraphNode base1, AEGraphNode destroyed, AEScene modul_root, int tx, int ty, int tz, int rx, int ry, int rz, int hitpoints, int hitradius, AEExplosionInterface explosion, SCWeaponSystem[] weapon, int[] target_count_array, int target_count_id, long tile) {
        this.shoot_node.setRotation(0, 2048, 0);
        this.base_root.setTranslation(tx, ty, tz);
        this.base_root.setRotation(rx, ry, rz);
        this.base1 = base1;
        this.base1.stopAnim(0);
        this.base1.setRotation(0, 2048, 0);
        this.base_root.addChild(base1);
        this.base_root.addChild(this.shoot_node);
        this.destroyed = destroyed;
        destroyed.stopAnim(0);
        this.initial_hitpoints = this.hitpoints = hitpoints;
        this.hitradius = hitradius;
        this.explosion = explosion;
        if (explosion != null) {
            explosion.getParticleSystem().setTranslation(tx, ty, tz);
        }
        this.weapon = weapon;
        this.target_count_array = target_count_array;
        this.target_count_id = target_count_id;
        this.tile = tile;
        if (rndm == null) {
            rndm = new Random();
        }
        this.initial_x = tx;
        this.initial_z = tz;
        this.target_x = 2048;
        this.target_z = 1024;
        this.time = 0;
        this.dir = new AEVector3D(0, 0, 4096);
        this.up = new AEVector3D(0, 4096, 0);
        this.left = new AEVector3D();
        canShoot = false;
        this.initial_shoot_delay = 3000L;
    }

    public void applyHitpoints(int hitpoints) {
        if (this.hitpoints <= 0) {
            return;
        }
        this.hitpoints += hitpoints;
        if (this.hitpoints <= 0) {
            AEGroup modul_root = this.base_root.getParent();
            if (modul_root != null) {
                modul_root.removeChild(this.base_root);
                this.destroyed.setTranslation(this.base1.getPositionX() + this.base_root.getPositionX(), this.base1.getPositionY() + this.base_root.getPositionY(), this.base1.getPositionZ() + this.base_root.getPositionZ());
                this.destroyed.setRotation(0, this.base1.getRotationY() + this.base_root.getRotationY(), 0);
                modul_root.addChild(this.destroyed);
                this.destroyed.playAnim((byte)1);
            }
            if (this.explosion != null) {
                this.explosion.getParticleSystem().setTranslation(this.base1.getPositionX() + this.base_root.getPositionX(), this.base1.getPositionY() + this.base_root.getPositionY(), this.base1.getPositionZ() + this.base_root.getPositionZ());
                this.explosion.start();
            }
            if (this.target_count_array != null) {
                int n = this.target_count_id;
                this.target_count_array[n] = this.target_count_array[n] + 1;
            }
        }
    }

    public int getCurrentX() {
        return this.base1.getWorldPositionX();
    }

    public int getCurrentY() {
        return this.base1.getWorldPositionY();
    }

    public int getCurrentZ() {
        return this.base1.getWorldPositionZ();
    }

    public AEGraphNode getGeometry() {
        return this.base_root;
    }

    public int getHitRadius() {
        return this.hitradius;
    }

    public int getHitpoints() {
        return this.hitpoints;
    }

    public boolean isDead() {
        return this.hitpoints <= 0 && (this.explosion == null || !this.explosion.isActive());
    }

    public void setEnemySet(SCEnemySet enemy_set) {
        this.enemy_set = enemy_set;
    }

    public void setHitpoints(int hitpoints) {
        this.hitpoints = hitpoints;
    }

    public void update(int elapsed_time) {
        if (this.isDead()) {
            this.enemy_set.removeEnemy(this);
            if (this.base_root.getParent() != null) {
                this.base_root.getParent().removeChild(this.base_root);
            }
        }
        if (this.explosion != null && this.explosion.isActive()) {
            this.explosion.update(elapsed_time);
        }
        if (this.weapon != null && canShoot) {
            int i;
            if (this.initial_shoot_delay > 0L) {
                this.initial_shoot_delay -= (long)elapsed_time;
            } else if (this.hitpoints > 0) {
                for (i = 0; i < this.weapon.length; ++i) {
                    this.weapon[i].shoot(this.shoot_node);
                }
            }
            for (i = 0; i < this.weapon.length; ++i) {
                this.weapon[i].update(elapsed_time);
                this.weapon[i].render();
            }
        }
        this.base1.translate(-(elapsed_time * this.dir.x >> 12), 0, -(elapsed_time * this.dir.z >> 12));
        this.shoot_node.setTranslation(this.base1.getPositionX(), this.base1.getPositionY(), this.base1.getPositionZ());
        int dx = this.base1.getPositionX() - this.target_x;
        int dz = this.base1.getPositionZ() - this.target_z;
        this.up.set(dx, 0, dz);
        this.up.normalize();
        int blend2 = elapsed_time << 3 > 4096 ? 4096 : elapsed_time << 3;
        int blend1 = 4096 - blend2;
        this.dir.x = (this.dir.x * blend1 >> 12) + (this.up.x * blend2 >> 12);
        this.dir.y = (this.dir.y * blend1 >> 12) + (this.up.y * blend2 >> 12);
        this.dir.z = (this.dir.z * blend1 >> 12) + (this.up.z * blend2 >> 12);
        this.dir.normalize();
        this.up.set(0, 4096, 0);
        this.left = this.up.cross(this.dir, this.left);
        this.base1.setRotationMatrix(this.left, this.up, this.dir);
        if (dx * dx + dz * dz < 90000) {
            this.target_x = rndm.nextInt(4096) - 2048;
            this.target_z = rndm.nextInt(2048) - 1024;
        }
        this.time += elapsed_time >> 1;
        int distx = this.base1.getWorldPositionX() - SCLevel.getCurrentX();
        int distz = this.base1.getWorldPositionZ() - SCLevel.getCurrentZ();
        distx = distx < 0 ? -distx : distx;
        int n = distz = distz < 0 ? -distz : distz;
        if (distz > distx) {
            this.corrected_hitradius_z = this.hitradius - ((distz * (this.base1.getWorldPositionY() - 700) >> 12) * 4096 >> 12);
            this.corrected_hitradius_x = this.hitradius;
        } else {
            this.corrected_hitradius_x = this.hitradius - ((distx * (this.base1.getWorldPositionY() - 700) >> 12) * 4096 >> 12);
            this.corrected_hitradius_z = this.hitradius;
        }
    }

    public AEGraphNode getExplosion() {
        return this.explosion != null ? this.explosion.getParticleSystem() : null;
    }

    public SCWeaponSystem getWeapon() {
        return null;
    }

    public void reinit(int tx, int ty, int tz, int rx, int ry, int rz, AEScene modul_root, long tile) {
    }

    public boolean isUsed() {
        return this.tile >= SCLevel.getCurrentTile() && this.tile < SCLevel.getCurrentTile() + (long)SCLevel.modul.length;
    }

    public boolean isHit(long x, long y, long z) {
        if (this.hitpoints <= 0) {
            return false;
        }
        int dx = (int)(x + SCLevel.global_tx - (long)this.base1.getWorldPositionX());
        int dz = (int)(z + SCLevel.global_tz - (long)this.base1.getWorldPositionZ());
        return dx <= this.corrected_hitradius_x && dx >= -this.corrected_hitradius_x && dz <= this.corrected_hitradius_z && dz >= -this.corrected_hitradius_z;
    }

    public int getEnemyClassId() {
        return this.target_count_id;
    }

    public void release() {
        if (this.base1 != null) {
            this.base1.release();
        }
        this.base1 = null;
        if (this.destroyed != null) {
            this.destroyed.release();
        }
        this.destroyed = null;
        if (this.base_root != null) {
            this.base_root.release();
        }
        this.base_root = null;
        if (this.shoot_node != null) {
            this.shoot_node.release();
        }
        this.shoot_node = null;
        if (this.enemy_set != null) {
            this.enemy_set.removeAllEnemies();
        }
        this.enemy_set = null;
        if (this.explosion != null) {
            this.explosion.release();
        }
        this.explosion = null;
        if (this.weapon != null) {
            for (int i = 0; i < this.weapon.length; ++i) {
                this.weapon[i].release();
                this.weapon[i] = null;
            }
        }
        this.weapon = null;
        this.target_count_array = null;
        this.dir = null;
        this.up = null;
        this.left = null;
        rndm = null;
    }

    public int getInitialHitpoints() {
        return this.initial_hitpoints;
    }
}

