/*
 * Decompiled with CFR 0.152.
 */
package ScrollerGame;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEGroup;
import AbyssEngine.AELookAtConstraint;
import AbyssEngine.AEScene;
import AbyssEngine.AEVector3D;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCEnemySet;
import ScrollerGame.SCLevel;
import ScrollerGame.SCWeaponSystem;
import contentHeliStrike.grh;

public class SCStaticEnemyTurret
implements SCEnemy {
    private AEGraphNode base1;
    private AEGraphNode base2;
    private AEGraphNode cannon;
    private AEGraphNode destroyed;
    private AEGroup base_root;
    private AEGroup cannon_root = new AEGroup();
    private int hitpoints;
    private int initial_hitpoints;
    private int hitradius;
    private int corrected_hitradius_z;
    private int corrected_hitradius_x;
    private SCEnemySet enemy_set;
    private AEExplosionInterface explosion;
    private SCWeaponSystem weapon;
    private int[] target_count_array;
    private int target_count_id;
    private long tile;

    public SCStaticEnemyTurret(AEGraphNode base1, AEGraphNode base2, AEGraphNode cannon, AEGraphNode destroyed, AEScene modul_root, int tx, int ty, int tz, int rx, int ry, int rz, int hitpoints, int hitradius, AEExplosionInterface explosion, SCWeaponSystem weapon, int[] target_count_array, int target_count_id, long tile) {
        this.base_root = new AEGroup();
        this.base_root.addChild(this.cannon_root);
        this.base_root.setTranslation(tx, ty, tz);
        this.base_root.setRotation(rx, ry, rz);
        this.base1 = base1;
        this.base1.stopAnim(0);
        this.base_root.addChild(base1);
        this.base2 = base2;
        this.base2.stopAnim(0);
        this.cannon_root.addChild(base2);
        this.cannon = cannon;
        this.cannon.stopAnim(0);
        this.cannon_root.addChild(cannon);
        modul_root.addConstraint(new AELookAtConstraint(SCLevel.getVehicle(), cannon));
        modul_root.addConstraint(new AELookAtConstraint(SCLevel.getVehicle(), this.cannon_root, new AEVector3D(0, 4096, 0)));
        if (destroyed != null) {
            this.destroyed = destroyed;
            this.destroyed.setTranslation(tx, ty, tz);
            this.destroyed.setRotation(rx, ry, rz);
            this.destroyed.stopAnim(0);
        }
        this.initial_hitpoints = this.hitpoints = hitpoints;
        this.hitradius = hitradius;
        this.explosion = explosion;
        if (explosion != null) {
            explosion.getParticleSystem().setTranslation(tx, ty, tz);
        }
        this.weapon = weapon;
        this.target_count_array = target_count_array;
        this.target_count_id = target_count_id;
        this.tile = tile;
    }

    public SCStaticEnemyTurret(AEGraphNode base1, AEGraphNode base2, AEGraphNode cannon, AEScene modul_root, int tx, int ty, int tz, int rx, int ry, int rz, int hitpoints, int hitradius, AEExplosionInterface explosion, SCWeaponSystem weapon, int[] target_count_array, int target_count_id, long tile) {
        this(base1, base2, cannon, null, modul_root, tx, ty, tz, rx, ry, rz, hitpoints, hitradius, explosion, weapon, target_count_array, target_count_id, tile);
    }

    public void applyHitpoints(int hitpoints) {
        if (this.hitpoints <= 0) {
            return;
        }
        this.hitpoints += hitpoints;
        if (this.hitpoints <= 0) {
            AEGroup modul_root = this.base_root.getParent();
            if (modul_root != null) {
                if (this.destroyed != null) {
                    modul_root.removeChild(this.base_root);
                    modul_root.addChild(this.destroyed);
                    this.destroyed.playAnim((byte)1);
                } else {
                    this.base_root.playAnim((byte)1);
                }
            }
            if (this.explosion != null) {
                this.explosion.getParticleSystem().setTranslation(this.base_root.getPositionX(), this.base_root.getPositionY(), this.base_root.getPositionZ());
                this.explosion.start();
            }
            if (this.target_count_array != null) {
                int n = this.target_count_id;
                this.target_count_array[n] = this.target_count_array[n] + 1;
            }
            ++grh.hit_notify;
        }
    }

    public int getCurrentX() {
        if (this.destroyed != null && this.hitpoints <= 0) {
            return this.destroyed.getWorldPositionX();
        }
        return this.base_root.getWorldPositionX();
    }

    public int getCurrentY() {
        if (this.destroyed != null && this.hitpoints <= 0) {
            return this.destroyed.getWorldPositionY();
        }
        return this.base_root.getWorldPositionY();
    }

    public int getCurrentZ() {
        if (this.destroyed != null && this.hitpoints <= 0) {
            return this.destroyed.getWorldPositionZ();
        }
        return this.base_root.getWorldPositionZ();
    }

    public AEGraphNode getGeometry() {
        return this.base_root;
    }

    public int getHitRadius() {
        return this.hitradius;
    }

    public int getHitpoints() {
        return this.hitpoints;
    }

    public boolean isDead() {
        return !(this.hitpoints > 0 || this.explosion != null && this.explosion.isActive() || this.weapon != null && this.weapon.isActive());
    }

    public void setEnemySet(SCEnemySet enemy_set) {
        this.enemy_set = enemy_set;
    }

    public void setHitpoints(int hitpoints) {
        this.hitpoints = hitpoints;
    }

    public void update(int elapsed_time) {
        if (this.isDead()) {
            this.enemy_set.removeEnemy(this);
            if (this.base_root.getParent() != null) {
                this.base_root.getParent().removeChild(this.base_root);
            }
        }
        if (this.explosion != null && this.explosion.isActive()) {
            this.explosion.update(elapsed_time);
        }
        if (this.weapon != null) {
            if (this.hitpoints > 0) {
                this.weapon.shoot(this.cannon);
            }
            this.weapon.update(elapsed_time);
        }
        int dx = this.base_root.getWorldPositionX() - SCLevel.getCurrentX();
        int dz = this.base_root.getWorldPositionZ() - SCLevel.getCurrentZ();
        dx = dx < 0 ? -dx : dx;
        int n = dz = dz < 0 ? -dz : dz;
        if (dz > dx) {
            this.corrected_hitradius_z = this.hitradius - ((dz * (this.base_root.getWorldPositionY() - 700) >> 12) * 4096 >> 12);
            this.corrected_hitradius_x = this.hitradius;
        } else {
            this.corrected_hitradius_x = this.hitradius - ((dx * (this.base_root.getWorldPositionY() - 700) >> 12) * 4096 >> 12);
            this.corrected_hitradius_z = this.hitradius;
        }
    }

    public AEGraphNode getExplosion() {
        return this.explosion != null ? this.explosion.getParticleSystem() : null;
    }

    public SCWeaponSystem getWeapon() {
        return this.weapon;
    }

    public void reinit(int tx, int ty, int tz, int rx, int ry, int rz, AEScene modul_root, long tile) {
        this.base_root.setTranslation(tx, ty, tz);
        this.base_root.setRotation(rx, ry, rz);
        this.base_root.stopAnim(0);
        if (this.destroyed != null) {
            this.destroyed.setTranslation(tx, ty, tz);
            this.destroyed.setRotation(rx, ry, rz);
            this.destroyed.stopAnim(0);
        }
        modul_root.addConstraint(new AELookAtConstraint(SCLevel.getVehicle(), this.cannon));
        modul_root.addConstraint(new AELookAtConstraint(SCLevel.getVehicle(), this.cannon_root, new AEVector3D(0, 4096, 0)));
        this.explosion = this.explosion;
        if (this.explosion != null) {
            this.explosion.getParticleSystem().setTranslation(tx, ty, tz);
        }
        this.hitpoints = this.initial_hitpoints;
        if (this.base_root.getParent() != null) {
            this.base_root.getParent().removeChild(this.base_root);
        }
        if (this.explosion != null && this.explosion.getParticleSystem().getParent() != null) {
            this.explosion.getParticleSystem().getParent().removeChild(this.explosion.getParticleSystem());
        }
        if (this.destroyed != null && this.destroyed.getParent() != null) {
            this.destroyed.getParent().removeChild(this.destroyed);
        }
        this.tile = tile;
        if (this.weapon != null) {
            this.weapon.reinit();
        }
    }

    public boolean isUsed() {
        return this.tile >= SCLevel.getCurrentTile() && this.tile < SCLevel.getCurrentTile() + (long)SCLevel.modul.length;
    }

    public boolean isHit(long x, long y, long z) {
        if (this.hitpoints <= 0) {
            return false;
        }
        int dx = (int)(x + SCLevel.global_tx - (long)this.base_root.getWorldPositionX());
        int dz = (int)(z + SCLevel.global_tz - (long)this.base_root.getWorldPositionZ());
        return dx <= this.corrected_hitradius_x && dx >= -this.corrected_hitradius_x && dz <= this.corrected_hitradius_z && dz >= -this.corrected_hitradius_z;
    }

    public int getEnemyClassId() {
        return this.target_count_id;
    }

    public void release() {
        if (this.base1 != null) {
            this.base1.release();
        }
        this.base1 = null;
        if (this.base2 != null) {
            this.base2.release();
        }
        this.base2 = null;
        if (this.cannon != null) {
            this.cannon.release();
        }
        this.cannon = null;
        if (this.destroyed != null) {
            this.destroyed.release();
        }
        this.destroyed = null;
        if (this.base_root != null) {
            this.base_root.release();
        }
        this.base_root = null;
        if (this.cannon_root != null) {
            this.cannon_root.release();
        }
        this.cannon_root = null;
        if (this.enemy_set != null) {
            this.enemy_set.removeAllEnemies();
        }
        this.enemy_set = null;
        if (this.explosion != null) {
            this.explosion.release();
        }
        this.explosion = null;
        if (this.weapon != null) {
            this.weapon.release();
        }
        this.weapon = null;
        this.target_count_array = null;
    }

    public int getInitialHitpoints() {
        return this.initial_hitpoints;
    }
}

