/*
 * Decompiled with CFR 0.152.
 */
package AppKit;

public class AEUserInput {
    private static final char[][] KEY_TABLE = new char[][]{{'1'}, {'A', 'B', 'C', '2'}, {'D', 'E', 'F', '3'}, {'G', 'H', 'I', '4'}, {'J', 'K', 'L', '5'}, {'M', 'N', 'O', '6'}, {'P', 'Q', 'R', 'S', '7'}, {'T', 'U', 'V', '8'}, {'W', 'X', 'Y', 'Z', '9'}, {'*'}, {'+', '0'}, {' ', '#'}};
    private static final long CYCLE_DELAY = 1000L;
    private static final long KEY_DELAY = 0L;
    private String user_input;
    private int cycle_id;
    private int last_key;
    private long last_time;
    private long current_time;
    private boolean wait;
    private int maxLength;

    public AEUserInput(int maxLength) {
        this.maxLength = maxLength;
        this.user_input = "_";
        this.wait = true;
    }

    public void update(long current_time) {
        this.current_time = current_time;
        if (current_time - this.last_time > 1000L && !this.wait && this.user_input.length() < this.maxLength) {
            this.user_input = this.user_input + "_";
            this.last_time = current_time;
            this.last_key = 0;
            this.cycle_id = 0;
            this.wait = true;
        }
    }

    public void processKey(int key) {
        if (this.current_time - this.last_time < 0L) {
            return;
        }
        if (key == 0x400000 || key == 8192) {
            if (this.user_input.length() > 1) {
                this.user_input = this.user_input.substring(0, this.user_input.length() - 2) + "_";
            }
            this.last_key = 0;
            this.cycle_id = 0;
            this.last_time = this.current_time;
            this.wait = true;
            return;
        }
        int current_key_table_id = this.keyMapHash(key);
        if (current_key_table_id == -1) {
            this.last_time = this.current_time;
            return;
        }
        int n = this.cycle_id = this.cycle_id < KEY_TABLE[current_key_table_id].length ? this.cycle_id : 0;
        if (key == this.last_key && this.current_time - this.last_time < 1000L || this.last_key == 0 || this.last_time == 0L) {
            this.user_input = this.user_input.substring(0, this.user_input.length() - 1) + KEY_TABLE[current_key_table_id][this.cycle_id];
            this.cycle_id = this.cycle_id < KEY_TABLE[current_key_table_id].length - 1 ? this.cycle_id + 1 : 0;
            this.wait = false;
        } else if (this.user_input.endsWith("_")) {
            this.cycle_id = 0;
            this.user_input = this.user_input.substring(0, this.user_input.length() - 1) + KEY_TABLE[current_key_table_id][this.cycle_id];
            this.wait = true;
        } else if (this.user_input.length() < this.maxLength) {
            this.cycle_id = 0;
            this.user_input = this.user_input + KEY_TABLE[current_key_table_id][this.cycle_id];
            this.wait = false;
        }
        this.last_key = key;
        this.last_time = this.current_time;
    }

    public void clear() {
        this.user_input = "_";
        this.last_time = 0L;
        this.current_time = 0L;
        this.cycle_id = 0;
        this.last_key = 0;
        this.wait = true;
    }

    public String getCurrentUserInput() {
        return this.user_input;
    }

    public boolean isCycling() {
        return this.current_time - this.last_time < 1000L || this.wait;
    }

    private int keyMapHash(int key) {
        switch (key) {
            case 2: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 16: {
                return 3;
            }
            case 32: {
                return 4;
            }
            case 64: {
                return 5;
            }
            case 128: {
                return 6;
            }
            case 256: {
                return 7;
            }
            case 512: {
                return 8;
            }
            case 1024: {
                return 9;
            }
            case 1: {
                return 10;
            }
            case 2048: {
                return 11;
            }
        }
        return -1;
    }
}

