/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AECamera;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEParticleAccess;
import AbyssEngine.AERenderer;
import AbyssEngine.AETexture;
import AbyssEngine.AEVector3D;
import AbyssEngine.JSRDevice;
import AbyssEngine.JSRTexture;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class JSRParticleSystem
extends AEGeometry
implements AEParticleAccess {
    private static Transform tmp_particle_pos = new Transform();
    private static AEVector3D ppos = new AEVector3D();
    private Appearance ap;
    private static PolygonMode pm;
    private int count;
    private Mesh mesh;
    private int[] pos;
    private int[] color;
    private int[] size;
    private float single_size;
    private byte blend_mode;

    public JSRParticleSystem(int tex_size, int u1, int v1, int u2, int v2, int size, int count, byte blend_mode) {
        this.blend_mode = blend_mode;
        this.ap = new Appearance();
        CompositingMode cm = new CompositingMode();
        switch (blend_mode) {
            case 1: 
            case 3: {
                cm.setBlending(64);
                cm.setDepthWriteEnable(false);
                cm.setDepthTestEnable(true);
                break;
            }
            case 2: {
                cm.setBlending(65);
                cm.setDepthWriteEnable(false);
                cm.setDepthTestEnable(true);
                break;
            }
            case 0: {
                cm.setBlending(68);
                cm.setDepthWriteEnable(true);
                cm.setDepthTestEnable(true);
            }
        }
        this.ap.setCompositingMode(cm);
        if (pm == null) {
            pm = new PolygonMode();
            pm.setCulling(160);
            pm.setShading(164);
            pm.setPerspectiveCorrectionEnable(false);
        }
        this.ap.setPolygonMode(pm);
        this.count = count;
        this.pos = new int[3 * count];
        this.color = new int[count];
        for (int i = 0; i < this.color.length; ++i) {
            this.color[i] = -1;
        }
        VertexBuffer vb = new VertexBuffer();
        VertexArray vtx_pos = new VertexArray(4, 3, 1);
        VertexArray vtx_uv = new VertexArray(4, 2, 2);
        byte[] vtx_pos_data = new byte[]{-1, 1, 0, 1, 1, 0, 1, -1, 0, -1, -1, 0};
        vtx_pos.set(0, 4, vtx_pos_data);
        short[] vtx_uv_data = new short[]{(short)u1, (short)v1, (short)u2, (short)v1, (short)u2, (short)v2, (short)u1, (short)v2};
        vtx_uv.set(0, 4, vtx_uv_data);
        float[] pos_bias = new float[]{0.0f, 0.0f, 0.0f};
        vb.setPositions(vtx_pos, 1.0f, pos_bias);
        float[] uv_bias = new float[]{0.0f, 0.0f};
        vb.setTexCoords(0, vtx_uv, 1.0f / (float)tex_size, uv_bias);
        int[] tri_strip = new int[]{0, 2, 1, 3, 2, 0};
        int[] tri_strip_length = new int[]{3, 3};
        TriangleStripArray ib = new TriangleStripArray(tri_strip, tri_strip_length);
        this.mesh = new Mesh(vb, (IndexBuffer)ib, this.ap);
        this.culling_radius = size >> 1;
        this.single_size = size >> 1;
        this.size = null;
    }

    public JSRParticleSystem(JSRParticleSystem psystem) {
        this.count = psystem.count;
        this.pos = new int[3 * this.count];
        this.color = new int[this.count];
        System.arraycopy(psystem.color, 0, this.color, 0, this.color.length);
        System.arraycopy(psystem.pos, 0, this.pos, 0, this.pos.length);
        this.mesh = psystem.mesh;
        this.culling_radius = psystem.culling_radius;
        this.single_size = psystem.single_size;
        this.isVisible = psystem.isVisible;
        this.layer_id = psystem.layer_id;
        if (psystem.size != null) {
            this.size = new int[this.count];
            System.arraycopy(psystem.size, 0, this.size, 0, this.size.length);
        }
    }

    public AEGraphNode copy() {
        return new JSRParticleSystem(this);
    }

    public void release() {
        super.release();
        this.ap = null;
        this.mesh = null;
        this.pos = null;
        this.color = null;
        this.size = null;
    }

    public void prerender(AECamera camera, AERenderer renderer) {
        if (this.isVisible) {
            this.render_matrix = camera.world.getInverse(this.render_matrix);
            this.render_matrix.multiply(this.world);
            renderer.add2Layer(this.layer_id, this);
        }
    }

    public void render() {
        if (this.blend_mode == 0) {
            int pos_indx = 0;
            int i = 0;
            while (i < this.count) {
                ppos.set(this.pos[pos_indx], this.pos[pos_indx + 1], this.pos[pos_indx + 2]);
                ppos = this.render_matrix.transform(ppos);
                tmp_particle_pos.setIdentity();
                tmp_particle_pos.postTranslate((float)JSRParticleSystem.ppos.x, (float)JSRParticleSystem.ppos.y, (float)JSRParticleSystem.ppos.z);
                if (this.size != null) {
                    tmp_particle_pos.postScale((float)(this.size[i] >> 1), (float)(this.size[i] >> 1), (float)(this.size[i] >> 1));
                } else {
                    tmp_particle_pos.postScale(this.single_size, this.single_size, this.single_size);
                }
                this.mesh.getVertexBuffer().setDefaultColor(this.color[i]);
                JSRDevice.device.render((Node)this.mesh, tmp_particle_pos);
                ++i;
                pos_indx += 3;
            }
        }
    }

    public void renderTransp() {
        if (this.blend_mode != 0) {
            int pos_indx = 0;
            int i = 0;
            while (i < this.count) {
                ppos.set(this.pos[pos_indx], this.pos[pos_indx + 1], this.pos[pos_indx + 2]);
                ppos = this.render_matrix.transform(ppos);
                tmp_particle_pos.setIdentity();
                tmp_particle_pos.postTranslate((float)JSRParticleSystem.ppos.x, (float)JSRParticleSystem.ppos.y, (float)JSRParticleSystem.ppos.z);
                if (this.size != null) {
                    tmp_particle_pos.postScale((float)(this.size[i] >> 1), (float)(this.size[i] >> 1), (float)(this.size[i] >> 1));
                } else {
                    tmp_particle_pos.postScale(this.single_size, this.single_size, this.single_size);
                }
                this.mesh.getVertexBuffer().setDefaultColor(this.color[i]);
                JSRDevice.device.render((Node)this.mesh, tmp_particle_pos);
                ++i;
                pos_indx += 3;
            }
        }
    }

    public void setTexture(AETexture texture) {
        Texture2D tex = new Texture2D(((JSRTexture)texture).getData()[0].getImage());
        this.ap.setTexture(0, tex);
    }

    public int[] getPositions() {
        return this.pos;
    }

    public int[] getColors() {
        return this.color;
    }

    public int[] getSizes() {
        if (this.size == null) {
            this.size = new int[this.count];
            for (int i = 0; i < this.size.length; ++i) {
                this.size[i] = (int)this.single_size;
            }
        }
        return this.size;
    }
}

