/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEMath;

public class AEVector3D {
    public int x;
    public int y;
    public int z;

    public AEVector3D(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public AEVector3D() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public AEVector3D(AEVector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void set(AEVector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int dot(AEVector3D v) {
        return (this.x * v.x >> 12) + (this.y * v.y >> 12) + (this.z * v.z >> 12);
    }

    public int dotL(AEVector3D v) {
        return (int)(((long)this.x * (long)v.x >> 12) + ((long)this.y * (long)v.y >> 12) + ((long)this.z * (long)v.z >> 12));
    }

    public AEVector3D cross(AEVector3D v, AEVector3D result) {
        result.x = (this.y * v.z >> 12) - (this.z * v.y >> 12);
        result.y = (this.z * v.x >> 12) - (this.x * v.z >> 12);
        result.z = (this.x * v.y >> 12) - (this.y * v.x >> 12);
        return result;
    }

    public AEVector3D crossL(AEVector3D v, AEVector3D result) {
        result.x = (int)(((long)this.y * (long)v.z >> 12) - ((long)this.z * (long)v.y >> 12));
        result.y = (int)(((long)this.z * (long)v.x >> 12) - ((long)this.x * (long)v.z >> 12));
        result.z = (int)(((long)this.x * (long)v.y >> 12) - ((long)this.y * (long)v.x >> 12));
        return result;
    }

    public void cross(AEVector3D v) {
        int origX = this.x;
        int origY = this.y;
        this.x = (this.y * v.z >> 12) - (this.z * v.y >> 12);
        this.y = (this.z * v.x >> 12) - (origX * v.z >> 12);
        this.z = (origX * v.y >> 12) - (origY * v.x >> 12);
    }

    public AEVector3D add(AEVector3D v, AEVector3D result) {
        result.x = this.x + v.x;
        result.y = this.y + v.y;
        result.z = this.z + v.z;
        return result;
    }

    public void add(AEVector3D v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public AEVector3D sub(AEVector3D v, AEVector3D result) {
        result.x = this.x - v.x;
        result.y = this.y - v.y;
        result.z = this.z - v.z;
        return result;
    }

    public void sub(AEVector3D v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public AEVector3D mul(int s, AEVector3D result) {
        result.x = (int)((long)s * (long)this.x >> 12);
        result.y = (int)((long)s * (long)this.y >> 12);
        result.z = (int)((long)s * (long)this.z >> 12);
        return result;
    }

    public void mul(int s) {
        this.x = (int)((long)s * (long)this.x >> 12);
        this.y = (int)((long)s * (long)this.y >> 12);
        this.z = (int)((long)s * (long)this.z >> 12);
    }

    public AEVector3D div(int s, AEVector3D result) {
        result.x = (this.x << 12) / s;
        result.y = (this.y << 12) / s;
        result.z = (this.z << 12) / s;
        return result;
    }

    public void div(int s) {
        this.x = (this.x << 12) / s;
        this.y = (this.y << 12) / s;
        this.z = (this.z << 12) / s;
    }

    public AEVector3D normalize(AEVector3D result) {
        int d = AEMath.invsqrt((int)(((long)this.x * (long)this.x >> 12) + ((long)this.y * (long)this.y >> 12) + ((long)this.z * (long)this.z >> 12)));
        result.x = this.x * d >> 12;
        result.y = this.y * d >> 12;
        result.z = this.z * d >> 12;
        return result;
    }

    public void normalize() {
        this.normalize(this);
    }

    public int length() {
        return AEMath.sqrt(((long)this.x * (long)this.x >> 12) + ((long)this.y * (long)this.y >> 12) + ((long)this.z * (long)this.z >> 12));
    }

    public int invLength() {
        return AEMath.invsqrt((int)(((long)this.x * (long)this.x >> 12) + ((long)this.y * (long)this.y >> 12) + ((long)this.z * (long)this.z >> 12)));
    }

    public String toString() {
        return "AEVector3D | " + this.x + ",\t" + this.y + ",\t" + this.z;
    }
}

