/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SynFont {
    private String strImageFile;
    private String strBinFile;
    public Image[] imgFont;
    public Image imgFontDraw;
    public int[][] fontDataArray;
    private byte bTotalFonts;
    private byte bWidthOfSpace;
    private byte bSpacing;
    private byte bFont_Height;

    public SynFont(String string, String string2, byte by, byte by2) {
        this.bWidthOfSpace = by;
        this.bSpacing = by2;
        this.initializeFont(string, string2);
    }

    public void initializeFont(String string, String string2) {
        this.imgFont = new Image[3];
        this.imgFont[0] = SynImage.createImage(string);
        this.bTotalFonts = 1;
        this.imgFontDraw = this.imgFont[0];
        this.fontDataArray = this.readFontFile(string2);
        this.bFont_Height = (byte)this.fontDataArray[65][3];
    }

    public boolean loadColorPallate(int[] nArray, int[] nArray2) {
        if (this.bTotalFonts > 2) {
            return false;
        }
        this.imgFont[this.bTotalFonts] = SynImage.changeColors(this.imgFont[0], nArray, nArray2);
        this.imgFontDraw = this.imgFont[this.bTotalFonts];
        this.bTotalFonts = (byte)(this.bTotalFonts + 1);
        return true;
    }

    public boolean loadColorPallate(int[] nArray, int[] nArray2, int n) {
        if (this.bTotalFonts > 2) {
            return false;
        }
        this.imgFont[n] = SynImage.changeColors(this.imgFont[0], nArray, nArray2);
        this.imgFontDraw = this.imgFont[n];
        this.bTotalFonts = (byte)(this.bTotalFonts + 1);
        return true;
    }

    public int[][] readFontFile(String string) {
        int[][] nArray = new int[256][4];
        DataInputStream dataInputStream = new DataInputStream("".getClass().getResourceAsStream(string));
        if (dataInputStream != null) {
            byte[] byArray = new byte[1024];
            try {
                ((InputStream)dataInputStream).read(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                System.out.println("Exception while reading Font Bin" + exception);
            }
            int n = 0;
            for (int i = 0; i < 256; ++i) {
                int n2 = 0;
                while (n2 < 4) {
                    nArray[i][n2] = 0xFF & byArray[n];
                    ++n2;
                    ++n;
                }
            }
        }
        return nArray;
    }

    public void setColor(Graphics graphics, int n) {
        graphics.setColor(n);
    }

    public void setColor(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(n, n2, n3);
    }

    public void setFont(int n) {
        this.imgFontDraw = n < this.bTotalFonts ? this.imgFont[n] : this.imgFont[0];
    }

    public int getStringWidth(String string) {
        int n = 0;
        int n2 = -1;
        string = string.toUpperCase();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            n2 = c;
            if (n2 != 32) {
                n += this.fontDataArray[n2][2] - 1 + this.bSpacing;
                continue;
            }
            n += this.bWidthOfSpace;
        }
        return n;
    }

    public int getFontHeight() {
        return this.fontDataArray[65][3];
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = -1;
        string = string.toUpperCase();
        int n7 = 0;
        for (n5 = 0; n5 < string.length(); ++n5) {
            n4 = string.charAt(n5);
            n6 = n4;
            if (n6 != 32) {
                n7 += this.fontDataArray[n6][2] - 1 + this.bSpacing;
                continue;
            }
            n7 += this.bWidthOfSpace;
        }
        if ((n3 & 1) != 0) {
            n -= n7 / 2;
        } else if ((n3 & 8) != 0) {
            n -= n7;
        }
        if ((n3 & 2) != 0) {
            n2 -= this.bFont_Height / 2;
        }
        if ((n3 & 0x20) != 0) {
            n2 -= this.bFont_Height;
        }
        n5 = 0;
        for (n4 = 0; n4 < string.length(); ++n4) {
            char c = string.charAt(n4);
            n6 = c;
            if (c != ' ') {
                int n8 = this.fontDataArray[n6][0];
                int n9 = this.fontDataArray[n6][1];
                int n10 = this.fontDataArray[n6][2];
                int n11 = this.fontDataArray[n6][3];
                try {
                    int n12 = graphics.getClipX();
                    int n13 = graphics.getClipY();
                    int n14 = graphics.getClipWidth();
                    int n15 = graphics.getClipHeight();
                    if (n + n5 + n10 < n12 || n2 + n11 < n13 || n + n5 > n12 + n14 || n2 > n13 + n15) continue;
                    int n16 = n13 - n2;
                    int n17 = n2 + n11 - (n13 + n15);
                    if (n16 < 0) {
                        n16 = 0;
                    }
                    if (n17 < 0) {
                        n17 = 0;
                    }
                    n2 = (n3 & 2) != 0 ? (n2 -= n11 - this.bFont_Height >> 1) : ((n3 & 0x20) != 0 ? (n2 -= n11 - this.bFont_Height) : (n2 -= n11 - this.bFont_Height));
                    graphics.setClip(n + n5, n2 + n16, n10, n11 - n17 - n16);
                    graphics.drawImage(this.imgFontDraw, n + n5 - n8, n2 - n9, 20);
                    graphics.setClip(n12, n13, n14, n15);
                    n2 = (n3 & 2) != 0 ? (n2 += n11 - this.bFont_Height >> 1) : ((n3 & 0x20) != 0 ? (n2 += n11 - this.bFont_Height) : (n2 += n11 - this.bFont_Height));
                    n5 += this.fontDataArray[n6][2] - 1 + this.bSpacing;
                }
                catch (Exception exception) {
                    System.out.println("Exception while drawing Region of ch" + c);
                }
                continue;
            }
            n5 += this.bWidthOfSpace;
        }
    }

    public int drawStringWrap(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        try {
            string = string.toUpperCase();
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            boolean bl = false;
            int n10 = 0;
            Vector<String> vector = new Vector<String>();
            int n11 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                char c2 = c;
                if (c2 != ' ') {
                    n7 += this.fontDataArray[c2][2] - 1 + this.bSpacing;
                    continue;
                }
                if (n10 + n7 > n4) {
                    String string2 = string.substring(n8, n9);
                    vector.addElement(string2);
                    n8 = n9 + 1;
                    n10 = n7;
                    n7 = 0;
                }
                n9 = i;
                n10 += (n7 += this.bWidthOfSpace);
                n7 = 0;
            }
            if (n10 + n7 > n4) {
                String string3 = string.substring(n8, n9);
                vector.addElement(string3);
                n8 = n9 + 1;
                n10 = n7;
                n7 = 0;
            }
            n10 += (n7 += this.bWidthOfSpace);
            n7 = 0;
            String string4 = string.substring(n8, string.length());
            vector.addElement(string4);
            if ((n3 & 2) != 0) {
                n2 -= vector.size() * (this.bFont_Height + 5) - 5 >> 1;
            }
            if ((n3 & 0x20) != 0) {
                n2 = n2 - vector.size() * (this.bFont_Height + 5) - 5;
            }
            n3 = (n3 & 1) != 0 ? 17 : ((n3 & 8) != 0 ? 24 : 20);
            for (n11 = 0; n11 < vector.size(); ++n11) {
                String string5 = (String)vector.elementAt(n11);
                this.drawString(graphics, string5, n, n2 + n11 * (this.bFont_Height + 5), n3);
                n6 += this.bFont_Height + 5;
            }
        }
        catch (Exception exception) {
            System.out.println("E:" + exception);
        }
        return n6 -= 5;
    }

    public int getHeightStringWrap(String string, int n, int n2, int n3, int n4) {
        int n5 = 0;
        try {
            string = string.toUpperCase();
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            boolean bl = false;
            int n9 = 0;
            Vector<String> vector = new Vector<String>();
            int n10 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                char c2 = c;
                if (c2 != ' ') {
                    n6 += this.fontDataArray[c2][2] - 1 + this.bSpacing;
                    continue;
                }
                if (n9 + n6 > n3) {
                    String string2 = string.substring(n7, n8);
                    vector.addElement(string2);
                    n7 = n8 + 1;
                    n9 = n6;
                    n6 = 0;
                }
                n8 = i;
                n9 += (n6 += this.bWidthOfSpace);
                n6 = 0;
            }
            if (n9 + n6 > n3) {
                String string3 = string.substring(n7, n8);
                vector.addElement(string3);
                n7 = n8 + 1;
                n9 = n6;
                n6 = 0;
            }
            n9 += (n6 += this.bWidthOfSpace);
            n6 = 0;
            String string4 = string.substring(n7, string.length());
            vector.addElement(string4);
            for (n10 = 0; n10 < vector.size(); ++n10) {
                String string5 = (String)vector.elementAt(n10);
                n5 += this.bFont_Height + 5;
            }
        }
        catch (Exception exception) {
            System.out.println("E:" + exception);
        }
        return n5 -= 5;
    }
}

