/*
    Copyright 2011 - Tommi Laukkanen (www.substanceofcode.com)

    This file is part of TwimGo.

    TwimGo is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    TwimGo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TwimGo. If not, see <http://www.gnu.org/licenses/>.
*/

import Qt 4.7

Item {
    id: profileDialogItem
    signal showTweets()
    signal follow()
    signal unfollow()
    signal directTweet(string userID, string username)
    signal sendMsg(string userID, string username)
    signal goBack()
    anchors.fill: parent
    property string userID: ""
    property string profileImageURL: ""
    property string username: ""
    property string userURL: ""
    property string userLocation: "Unknown"
    property string followersCount: "0"
    property string followingCount: "0"
    property string tweetCount: "0"
    property string description: ""
    property bool isFollowing: true

    Rectangle {
        id: profileDialog
        width: parent.width
        y: 0
        height: parent.height
	
        color: theme.detailBG
        /*
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#ccc" }
            GradientStop { position: 0.8; color: "#ccc" }
            GradientStop { position: 1.0; color: "#999" }
        }*/

        Column {
            x: 10
            width: parent.width - 20
            spacing: 10
            y: 10

            Row {
                spacing: 10
                width: parent.width
                height: 42

                Image {
                    id: profileImage
                    source: profileImageURL
                    width: 42
                    height: 42
                }

                Column {
                    //anchors.verticalCenter: parent.verticalCenter
                    width: parent.width - 66

                    Text {
                        id: usernameLabel
                        color: theme.dialogTextColor // "#eee"
                        text: username
                        wrapMode: Text.WordWrap
                        width: parent.width
                        //y: 10
                        font.pixelSize: 18
                    }

                    Text {
                        id: locationLabel
                        color: theme.dialogTextColor //"#ddd"
                        text: userLocation
                        wrapMode: Text.WordWrap
                        width: parent.width
                        font.pixelSize: 18
                    }

                }


            }

            Rectangle {
                height: profileDescription.height + 20
                width: parent.width
                radius: 5
                color: theme.dialogTextBG // "#bbb"

                Text {
                    id: profileDescription
                    text: description
                    font.pixelSize: 16
                    wrapMode: Text.WordWrap
                    width: parent.width - 20
                    x: 10
                    y: 10
                    color: theme.dialogTextColor // "#111"
                }
            }
            Row {
                width: parent.width - 5
                height: 60
                spacing: 10
                x: 0

                Rectangle {
                    y: 10
                    radius: 5
                    color: theme.dialogTextBG // "#aaa"
                    width: parent.width/3 - 5
                    height: 50
                    Text {
                        text: qsTr("Tweets")
                        font.pixelSize: 12
                        color: "#666"
                        x: 2
                        y: 2
                    }
                    Text {
                        text: tweetCount
                        width: parent.width-10
                        height: parent.height
                        font.pixelSize: 18
                        horizontalAlignment: Text.AlignRight
                        verticalAlignment: Text.AlignVCenter
                        color: theme.dialogTextColor //"#111"
                    }
                }
                Rectangle {
                    y: 10
                    radius: 5
                    color: theme.dialogTextBG //"#aaa"
                    width: parent.width/3 - 5
                    height: 50
                    Text {
                        text: qsTr("Following")
                        font.pixelSize: 12
                        color: "#666"
                        x: 2
                        y: 2
                    }
                    Text {
                        width: parent.width-10
                        height: parent.height
                        text: followingCount
                        font.pixelSize: 18
                        horizontalAlignment: Text.AlignRight
                        verticalAlignment: Text.AlignVCenter
                        color: theme.dialogTextColor //"#111"
                    }
                }
                Rectangle {
                    y: 10
                    radius: 5
                    color: theme.dialogTextBG //"#aaa"
                    width: parent.width/3 - 5
                    height: 50
                    Text {
                        text: qsTr("Followers")
                        font.pixelSize: 12
                        color: "#666"
                        x: 2
                        y: 2
                    }
                    Text {
                        text: followersCount
                        width: parent.width-10
                        height: parent.height
                        font.pixelSize: 18
                        verticalAlignment: Text.AlignVCenter
                        horizontalAlignment: Text.AlignRight
                        color: theme.dialogTextColor //"#111"
                    }
                }
            }

            Rectangle {
                radius: 5
                color: theme.dialogButtonAreaBG // "#999"
                //y: tweetTextContainer.y + tweetTextContainer.height + 20
                width: parent.width
                height: tweetActions.height
		
                Column {
                    id: tweetActions
                    x: 10
                    y: 10
                    width: parent.width - 20
                    height: 130
                    spacing: 10

                    Row {
                        width: parent.width
                        spacing: 10
                        height: 50
                        Button {
                            id: followButton
                            label: isFollowing ? "Unfollow" : "Follow"
                            height: 50
                            width: parent.width/2 - 5
                            onClicked: {
                                if(isFollowing) {
                                    profileDialogItem.unfollow();
                                } else {
                                    profileDialogItem.follow();
                                }
                                isFollowing = !isFollowing;
                            }
                        }
                        Button {
                            label: qsTr("Tweets")
                            height: 50
                            width: parent.width/2 -5
                            onClicked: {
                                profileDialogItem.showTweets();
                            }
                        }
                    }
                    Row {
                        width: parent.width
                        spacing: 10
                        height: 50
                        Button {
                            label: qsTr("Send")
                            height: 50
                            width: parent.width/2 - 5
                            onClicked: {
                                profileDialogItem.sendMsg(profileDialogItem.userID, profileDialogItem.username);
                            }
                        }
                        Button {
                            label: qsTr("DM")
                            height: 50
                            width: parent.width/2 - 5
                            onClicked: {
                                profileDialogItem.directTweet(profileDialogItem.userID, profileDialogItem.username);
                            }
                        }
                    }
                }
            }

        }

        BackButton {
            onClicked: {
                profileDialogItem.goBack();
            }
        }

    }

    states:
        State {
        name: "hidden"
        PropertyChanges {
            target: profileDialog
            y: 0 - profileDialog.height - 16
        }
    }
    State {
        name: "shown"
        PropertyChanges {
            target: profileDialog
            y: 0
        }
    }

    transitions: Transition {
        SequentialAnimation {
            PropertyAnimation {
                target: profileDialog
                properties: "y"
                duration: 600
                easing.type: "OutQuad"
            }
        }
    }

}
