/*
 * Decompiled with CFR 0.152.
 */
package org.MobileDb;

public class Utf8StringBuffer {
    StringBuffer _buffer;
    int _more;
    int _bits;
    boolean _errors;

    Utf8StringBuffer() {
        this._buffer = new StringBuffer();
    }

    Utf8StringBuffer(int capacity) {
        this._buffer = new StringBuffer(capacity);
    }

    public void append(byte[] b, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.append(b[i]);
        }
    }

    public void append(byte b) {
        if (b > 0) {
            if (this._more > 0) {
                this._buffer.append('?');
                this._more = 0;
                this._bits = 0;
            } else {
                this._buffer.append((char)(0x7F & b));
            }
        } else if (this._more == 0) {
            if ((b & 0xC0) != 192) {
                this._buffer.append('?');
                this._more = 0;
                this._bits = 0;
            } else if ((b & 0xE0) == 192) {
                this._more = 1;
                this._bits = b & 0x1F;
            } else if ((b & 0xF0) == 224) {
                this._more = 2;
                this._bits = b & 0xF;
            } else if ((b & 0xF8) == 240) {
                this._more = 3;
                this._bits = b & 7;
            } else if ((b & 0xFC) == 248) {
                this._more = 4;
                this._bits = b & 3;
            } else if ((b & 0xFE) == 252) {
                this._more = 5;
                this._bits = b & 1;
            }
        } else if ((b & 0xC0) == 192) {
            this._buffer.append('?');
            this._more = 0;
            this._bits = 0;
            this._errors = true;
        } else {
            this._bits = this._bits << 6 | b & 0x3F;
            if (--this._more == 0) {
                this._buffer.append((char)this._bits);
            }
        }
    }

    public int length() {
        return this._buffer.length();
    }

    public void reset() {
        this._buffer.setLength(0);
        this._more = 0;
        this._bits = 0;
        this._errors = false;
    }

    public StringBuffer getStringBuffer() {
        return this._buffer;
    }

    public String toString() {
        return this._buffer.toString();
    }

    public boolean isError() {
        return this._errors || this._more > 0;
    }
}

