/*
 * Decompiled with CFR 0.152.
 */
package org.MobileDb;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.MobileDb.Field;
import org.MobileDb.Row;
import org.MobileDb.Table;
import org.MobileDb.Utf8StringBuffer;

public class MobileDatabase {
    public int Version = 0;
    private Vector tables = new Vector();
    private boolean loadAllDataInMemory = true;
    private String path = null;
    private static boolean useNativeUtf8Decoder = true;

    public MobileDatabase() {
        useNativeUtf8Decoder = MobileDatabase.isSupportUtf8();
    }

    public void loadFrom(String path) throws IOException {
        this.loadAllDataInMemory = true;
        this.path = path;
        this.loadFrom(this.getClass().getResourceAsStream(path));
    }

    public void loadFrom(String path, boolean loadAllDataInMemory) throws IOException {
        this.loadAllDataInMemory = loadAllDataInMemory;
        this.path = path;
        this.loadFrom(this.getClass().getResourceAsStream(path));
    }

    public void loadFrom(InputStream stream) throws IOException {
        long position = 0L;
        long rowOffset = 0L;
        byte[] data = new byte[4];
        MobileDatabase.readDataFromStream(stream, data);
        position += 4L;
        this.Version = stream.read();
        ++position;
        long value = 0L;
        Table table = null;
        while ((value = (long)stream.read()) != -1L) {
            ++position;
            if (value == 9L) {
                int length = stream.read();
                ++position;
                data = new byte[length];
                MobileDatabase.readDataFromStream(stream, data);
                position += (long)length;
                table = new Table(MobileDatabase.getUtf8String(data), this.loadAllDataInMemory, this.path);
                this.tables.addElement(table);
                continue;
            }
            if (value == 10L) {
                int type = stream.read();
                ++position;
                int length = stream.read();
                ++position;
                data = new byte[length];
                MobileDatabase.readDataFromStream(stream, data);
                position += (long)length;
                table.addField(new Field(type, MobileDatabase.getUtf8String(data)));
                continue;
            }
            if (value != 11L) continue;
            rowOffset = position;
            Row row = table.createRow();
            for (int i = 0; i < row.fieldsCount(); ++i) {
                int type = row.getFieldType(i);
                if (type == Field.SMALL_INT) {
                    Integer row_value = new Integer(stream.read());
                    ++position;
                    row.setValue(i, row_value);
                    continue;
                }
                if (type == Field.SHORT_INT) {
                    byte[] tmp = new byte[2];
                    MobileDatabase.readDataFromStream(stream, tmp);
                    position += 2L;
                    Integer row_value = new Integer(MobileDatabase.shortIntFromBytes(tmp));
                    row.setValue(i, row_value);
                    continue;
                }
                if (type == Field.INT) {
                    byte[] tmp = new byte[4];
                    MobileDatabase.readDataFromStream(stream, tmp);
                    position += 4L;
                    Integer row_value = new Integer(MobileDatabase.intFromBytes(tmp));
                    row.setValue(i, row_value);
                    continue;
                }
                if (type == Field.TIME) {
                    byte[] tmp = new byte[4];
                    MobileDatabase.readDataFromStream(stream, tmp);
                    position += 4L;
                    Integer row_value = new Integer(MobileDatabase.intFromBytes(tmp));
                    row.setValue(i, row_value);
                    continue;
                }
                if (type == Field.NAME) {
                    int length = stream.read();
                    ++position;
                    byte[] tmp = new byte[length];
                    MobileDatabase.readDataFromStream(stream, tmp);
                    position += (long)length;
                    row.setValue(i, MobileDatabase.getUtf8String(tmp));
                    continue;
                }
                if (type == Field.TEXT) {
                    byte[] tmp = new byte[2];
                    MobileDatabase.readDataFromStream(stream, tmp);
                    position += 2L;
                    int length = MobileDatabase.shortIntFromBytes(tmp);
                    tmp = new byte[length];
                    MobileDatabase.readDataFromStream(stream, tmp);
                    position += (long)length;
                    row.setValue(i, MobileDatabase.getUtf8String(tmp));
                    continue;
                }
                if (type != Field.BINARY) continue;
                byte[] tmp = new byte[4];
                MobileDatabase.readDataFromStream(stream, tmp);
                position += 4L;
                int length = MobileDatabase.intFromBytes(tmp);
                tmp = new byte[length];
                MobileDatabase.readDataFromStream(stream, data);
                position += (long)length;
                row.setValue(i, tmp);
            }
            if (this.loadAllDataInMemory) {
                table.addRow(row);
                continue;
            }
            if (table.getOffset() == -1L) {
                table.setOffset(rowOffset);
            }
            table.addRow();
        }
        stream.close();
    }

    public Table getTable(int index) {
        if (index >= 0 && index < this.tables.size()) {
            return (Table)this.tables.elementAt(index);
        }
        return null;
    }

    public Table getTableByName(String name) {
        for (int i = 0; i < this.tables.size(); ++i) {
            Table table = (Table)this.tables.elementAt(i);
            if (!table.name.equals(name)) continue;
            return table;
        }
        return null;
    }

    public int tablesCount() {
        return this.tables.size();
    }

    public void optimize() {
        for (int i = 0; i < this.tables.size(); ++i) {
            Table table = (Table)this.tables.elementAt(i);
            table.optimize();
        }
        System.gc();
    }

    public static int shortIntFromBytes(byte[] arr) {
        int value = ((arr[1] & 0xFF) << 8) + (arr[0] & 0xFF);
        return value;
    }

    public static int intFromBytes(byte[] arr) {
        int value = ((arr[3] & 0xFF) << 24) + ((arr[2] & 0xFF) << 16) + ((arr[1] & 0xFF) << 8) + (arr[0] & 0xFF);
        return value;
    }

    public static boolean isSupportUtf8() {
        try {
            new String(new byte[]{50, 51}, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return true;
    }

    public static String getUtf8String(byte[] data) {
        if (useNativeUtf8Decoder) {
            String tmp = "";
            try {
                tmp = new String(data, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return tmp;
        }
        Utf8StringBuffer buffer = new Utf8StringBuffer();
        buffer.append(data, 0, data.length);
        return buffer.toString();
    }

    public static void readDataFromStream(InputStream stream, byte[] data) throws IOException {
        int pos = 0;
        int length = data.length;
        int read;
        while ((length -= (read = stream.read(data, pos, length))) != 0) {
            pos += read;
        }
        return;
    }
}

