/*
 * Decompiled with CFR 0.152.
 */
package org.MobileDb;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.MobileDb.Field;
import org.MobileDb.MobileDatabase;
import org.MobileDb.Row;

public class Table {
    public String name;
    private Vector fields;
    private Vector rows;
    private boolean optimized = false;
    private Field[] opt_fields = null;
    private Row[] opt_rows = null;
    private int last_find_index = -1;
    private Row last_find_row = null;
    private boolean loadAllDataInMemory = true;
    private String pathToDb = null;
    private boolean transaction = false;
    private InputStream inputStream = null;
    private int rowsCount = 0;
    private long _offset = -1L;

    public Table() {
        this.name = "";
        this.fields = new Vector();
        this.rows = new Vector();
    }

    public Table(String tableName) {
        this.name = tableName;
        this.fields = new Vector();
        this.rows = new Vector();
    }

    public Table(String tableName, boolean loadAllDataInMemory, String path) {
        this.name = tableName;
        this.fields = new Vector();
        this.loadAllDataInMemory = loadAllDataInMemory;
        if (loadAllDataInMemory) {
            this.rows = new Vector();
            this.pathToDb = null;
        } else {
            this.pathToDb = path;
        }
    }

    public void addField(Field field) {
        if (!this.optimized) {
            this.fields.addElement(field);
        }
    }

    public Field getField(int index) {
        if (this.optimized) {
            if (index >= 0 && index < this.opt_fields.length) {
                return this.opt_fields[index];
            }
        } else if (index >= 0 && index < this.fields.size()) {
            return (Field)this.fields.elementAt(index);
        }
        return null;
    }

    public void removeField(Field field) {
        if (!this.optimized) {
            this.fields.removeElement(field);
        }
    }

    public int fieldsCount() {
        if (this.optimized) {
            return this.opt_fields.length;
        }
        return this.fields.size();
    }

    public void removeAllFields() {
        if (!this.optimized) {
            this.fields.removeAllElements();
        }
    }

    public Row createRow() {
        if (!this.optimized) {
            int[] types = new int[this.fields.size()];
            for (int i = 0; i < this.fields.size(); ++i) {
                types[i] = ((Field)this.fields.elementAt((int)i)).type;
            }
            return new Row(types);
        }
        return null;
    }

    public void addRow(Row row) {
        if (!this.optimized) {
            this.rows.addElement(row);
        }
    }

    public void removeRow(Row row) {
        if (!this.optimized) {
            this.rows.removeElement(row);
        }
    }

    public int rowsCount() {
        if (this.loadAllDataInMemory) {
            if (this.optimized) {
                return this.opt_rows.length;
            }
            return this.rows.size();
        }
        return this.rowsCount;
    }

    public Row getRow(int index) {
        if (this.loadAllDataInMemory) {
            if (this.optimized) {
                if (index >= 0 && index < this.opt_rows.length) {
                    this.last_find_row = this.opt_rows[index];
                    this.last_find_index = index;
                    return this.last_find_row;
                }
            } else if (index >= 0 && index < this.rows.size()) {
                this.last_find_row = (Row)this.rows.elementAt(index);
                this.last_find_index = index;
                return this.last_find_row;
            }
        } else if (index >= 0 && index < this.rowsCount) {
            this.last_find_index = index;
            if (this.transaction) {
                InputStream stream = this.inputStream;
                try {
                    int value = stream.read();
                    if (value == 11) {
                        Row row = this.createRow();
                        for (int i = 0; i < row.fieldsCount(); ++i) {
                            int type = row.getFieldType(i);
                            if (type == Field.SMALL_INT) {
                                Integer row_value = new Integer(stream.read());
                                row.setValue(i, row_value);
                                continue;
                            }
                            if (type == Field.SHORT_INT) {
                                byte[] tmp = new byte[2];
                                MobileDatabase.readDataFromStream(stream, tmp);
                                Integer row_value = new Integer(MobileDatabase.shortIntFromBytes(tmp));
                                row.setValue(i, row_value);
                                continue;
                            }
                            if (type == Field.INT) {
                                byte[] tmp = new byte[4];
                                MobileDatabase.readDataFromStream(stream, tmp);
                                Integer row_value = new Integer(MobileDatabase.intFromBytes(tmp));
                                row.setValue(i, row_value);
                                continue;
                            }
                            if (type == Field.TIME) {
                                byte[] tmp = new byte[4];
                                MobileDatabase.readDataFromStream(stream, tmp);
                                Integer row_value = new Integer(MobileDatabase.intFromBytes(tmp));
                                row.setValue(i, row_value);
                                continue;
                            }
                            if (type == Field.NAME) {
                                int length = stream.read();
                                byte[] tmp = new byte[length];
                                MobileDatabase.readDataFromStream(stream, tmp);
                                row.setValue(i, MobileDatabase.getUtf8String(tmp));
                                continue;
                            }
                            if (type == Field.TEXT) {
                                byte[] tmp = new byte[2];
                                MobileDatabase.readDataFromStream(stream, tmp);
                                int length = MobileDatabase.shortIntFromBytes(tmp);
                                tmp = new byte[length];
                                MobileDatabase.readDataFromStream(stream, tmp);
                                row.setValue(i, MobileDatabase.getUtf8String(tmp));
                                continue;
                            }
                            if (type != Field.BINARY) continue;
                            byte[] tmp = new byte[4];
                            MobileDatabase.readDataFromStream(stream, tmp);
                            int length = MobileDatabase.intFromBytes(tmp);
                            tmp = new byte[length];
                            MobileDatabase.readDataFromStream(stream, tmp);
                            row.setValue(i, tmp);
                        }
                        this.last_find_row = row;
                        return this.last_find_row;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public void removeAllRows() {
        if (!this.loadAllDataInMemory) {
            return;
        }
        if (!this.optimized) {
            this.rows.removeAllElements();
        }
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public void optimize() {
        if (!this.loadAllDataInMemory) {
            return;
        }
        if (this.optimized) {
            return;
        }
        this.opt_fields = new Field[this.fields.size()];
        this.fields.copyInto(this.opt_fields);
        this.opt_rows = new Row[this.rows.size()];
        this.rows.copyInto(this.opt_rows);
        this.optimized = true;
        this.fields = null;
        this.rows = null;
        System.gc();
    }

    public Object getFieldValueByName(String name, int index) {
        if (this.loadAllDataInMemory) {
            if (this.optimized) {
                if (this.last_find_index != index && this.getRow(index) == null) {
                    return null;
                }
                for (int i = 0; i < this.opt_fields.length; ++i) {
                    if (!name.equals(this.opt_fields[i].name)) continue;
                    return this.last_find_row.getValue(i);
                }
            } else {
                if (this.last_find_index != index && this.getRow(index) == null) {
                    return null;
                }
                for (int i = 0; i < this.fields.size(); ++i) {
                    if (!name.equals(((Field)this.fields.elementAt((int)i)).name)) continue;
                    return this.last_find_row.getValue(i);
                }
            }
        } else {
            if (this.last_find_index != index && this.getRow(index) == null) {
                return null;
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                if (!name.equals(((Field)this.fields.elementAt((int)i)).name)) continue;
                return this.last_find_row.getValue(i);
            }
        }
        return null;
    }

    public void addRow() {
        ++this.rowsCount;
    }

    public void setOffset(long offset) {
        this._offset = offset - 1L;
    }

    public long getOffset() {
        return this._offset;
    }

    public void startTransaction() {
        if (this.loadAllDataInMemory) {
            return;
        }
        if (this.rowsCount == 0) {
            return;
        }
        try {
            this.inputStream = this.getClass().getResourceAsStream(this.pathToDb);
            this.inputStream.skip(this._offset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.transaction = true;
    }

    public void stopTransaction() {
        if (this.loadAllDataInMemory) {
            return;
        }
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.transaction = true;
    }
}

